/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.common.DroolsObjectInputStream;
import org.drools.facttemplates.FactTemplate;
import org.drools.rule.ConditionalElement;
import org.drools.rule.EvalCondition;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.ruleflow.common.core.Process;
import org.drools.util.StringUtils;

public class Package
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private String name;
    private Map rules;
    private Set imports;
    private List functions;
    private Set staticImports;
    private Map globals;
    private Map factTemplates;
    private Map ruleFlows;
    private PackageCompilationData packageCompilationData;
    private boolean valid = true;
    private String errorSummary;

    public Package() {
    }

    public Package(String name) {
        this(name, null);
    }

    public Package(String name, ClassLoader parentClassLoader) {
        this.name = name;
        this.imports = new HashSet();
        this.staticImports = Collections.EMPTY_SET;
        this.rules = new LinkedHashMap();
        this.ruleFlows = Collections.EMPTY_MAP;
        this.globals = Collections.EMPTY_MAP;
        this.factTemplates = Collections.EMPTY_MAP;
        this.functions = Collections.EMPTY_LIST;
        if (parentClassLoader == null && (parentClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        this.packageCompilationData = new PackageCompilationData(parentClassLoader);
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.packageCompilationData);
        stream.writeObject(this.name);
        stream.writeObject(this.imports);
        stream.writeObject(this.staticImports);
        stream.writeObject(this.functions);
        stream.writeObject(this.factTemplates);
        stream.writeObject(this.ruleFlows);
        stream.writeObject(this.globals);
        stream.writeBoolean(this.valid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.rules);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.packageCompilationData = (PackageCompilationData)stream.readObject();
        this.name = (String)stream.readObject();
        this.imports = (Set)stream.readObject();
        this.staticImports = (Set)stream.readObject();
        this.functions = (List)stream.readObject();
        this.factTemplates = (Map)stream.readObject();
        this.ruleFlows = (Map)stream.readObject();
        this.globals = (Map)stream.readObject();
        this.valid = stream.readBoolean();
        byte[] bytes = (byte[])stream.readObject();
        DroolsObjectInputStream streamWithLoader = new DroolsObjectInputStream(new ByteArrayInputStream(bytes), this.packageCompilationData.getClassLoader());
        this.rules = (Map)streamWithLoader.readObject();
    }

    public String getName() {
        return this.name;
    }

    public void addImport(String importEntry) {
        this.imports.add(importEntry);
    }

    public void removeImport(String importEntry) {
        this.imports.remove(importEntry);
    }

    public Set getImports() {
        return this.imports;
    }

    public void addStaticImport(String functionImport) {
        if (this.staticImports == Collections.EMPTY_SET) {
            this.staticImports = new HashSet(2);
        }
        this.staticImports.add(functionImport);
    }

    public void addFunction(String functionName) {
        if (this.functions == Collections.EMPTY_LIST) {
            this.functions = new ArrayList(1);
        }
        this.functions.add(functionName);
    }

    public List getFunctions() {
        return this.functions;
    }

    public void removeFunctionImport(String functionImport) {
        this.staticImports.remove(functionImport);
    }

    public Set getStaticImports() {
        return this.staticImports;
    }

    public void addGlobal(String identifier, Class clazz) {
        if (this.globals == Collections.EMPTY_MAP) {
            this.globals = new HashMap(1);
        }
        this.globals.put(identifier, clazz);
    }

    public void removeGlobal(String identifier) {
        this.globals.remove(identifier);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public PackageCompilationData removeFunction(String functionName) {
        if (!this.functions.remove(functionName)) {
            return null;
        }
        this.packageCompilationData.remove(this.name + "." + StringUtils.ucFirst(functionName));
        return this.packageCompilationData;
    }

    public FactTemplate getFactTemplate(String name) {
        return (FactTemplate)this.factTemplates.get(name);
    }

    public void addFactTemplate(FactTemplate factTemplate) {
        if (this.factTemplates == Collections.EMPTY_MAP) {
            this.factTemplates = new HashMap(1);
        }
        this.factTemplates.put(factTemplate.getName(), factTemplate);
    }

    public void addRule(Rule rule) {
        String name = rule.getName();
        this.rules.put(name, rule);
        rule.setLoadOrder(this.rules.size());
    }

    public void addRuleFlow(Process process) {
        if (this.ruleFlows == Collections.EMPTY_MAP) {
            this.ruleFlows = new HashMap();
        }
        this.ruleFlows.put(process.getId(), process);
    }

    public Map getRuleFlows() {
        return this.ruleFlows;
    }

    public void removeRuleFlow(String id) {
        if (!this.ruleFlows.containsKey(id)) {
            throw new IllegalArgumentException("The rule flow with id [" + id + "] is not part of this package.");
        }
        this.ruleFlows.remove(id);
    }

    public PackageCompilationData removeRule(Rule rule) {
        this.rules.remove(rule.getName());
        String consequenceName = rule.getConsequence().getClass().getName();
        if (this.packageCompilationData.remove(consequenceName)) {
            this.removeClasses(rule.getLhs());
            this.packageCompilationData.remove(consequenceName.substring(0, consequenceName.indexOf("ConsequenceInvoker")));
        }
        return this.packageCompilationData;
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            Iterator it = group.getChildren().iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.packageCompilationData.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        Iterator it = pattern.getConstraints().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof PredicateConstraint) {
                this.packageCompilationData.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(object instanceof ReturnValueConstraint)) continue;
            this.packageCompilationData.remove(((ReturnValueConstraint)object).getExpression().getClass().getName());
        }
    }

    public Rule getRule(String name) {
        return (Rule)this.rules.get(name);
    }

    public Rule[] getRules() {
        return this.rules.values().toArray(new Rule[this.rules.size()]);
    }

    public PackageCompilationData getPackageCompilationData() {
        return this.packageCompilationData;
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    public void setError(String summary) {
        this.errorSummary = summary;
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Package)) {
            return false;
        }
        Package other = (Package)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void clear() {
        this.rules.clear();
        this.packageCompilationData.clear();
        this.ruleFlows.clear();
        this.imports.clear();
        this.functions.clear();
        this.staticImports.clear();
        this.globals.clear();
        this.factTemplates.clear();
    }
}

