/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Serializable;
import org.drools.base.accumulators.AccumulateFunction;

public class MinAccumulateFunction
implements AccumulateFunction {
    private static final long serialVersionUID = -3230732263593698253L;

    public Object createContext() {
        return new MaxData();
    }

    public void init(Object context) throws Exception {
        MaxData data = (MaxData)context;
        data.min = Double.MAX_VALUE;
    }

    public void accumulate(Object context, Object value) {
        MaxData data = (MaxData)context;
        data.min = Math.min(data.min, ((Number)value).doubleValue());
    }

    public void reverse(Object context, Object value) throws Exception {
    }

    public Object getResult(Object context) throws Exception {
        MaxData data = (MaxData)context;
        return new Double(data.min);
    }

    public boolean supportsReverse() {
        return false;
    }

    protected static class MaxData
    implements Serializable {
        private static final long serialVersionUID = -2501515673470874786L;
        public double min = Double.MAX_VALUE;

        protected MaxData() {
        }
    }
}

