/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.drools.RuleBase;
import org.drools.event.AfterFunctionRemovedEvent;
import org.drools.event.AfterPackageAddedEvent;
import org.drools.event.AfterPackageRemovedEvent;
import org.drools.event.AfterRuleAddedEvent;
import org.drools.event.AfterRuleBaseLockedEvent;
import org.drools.event.AfterRuleBaseUnlockedEvent;
import org.drools.event.AfterRuleRemovedEvent;
import org.drools.event.BeforeFunctionRemovedEvent;
import org.drools.event.BeforePackageAddedEvent;
import org.drools.event.BeforePackageRemovedEvent;
import org.drools.event.BeforeRuleAddedEvent;
import org.drools.event.BeforeRuleBaseLockedEvent;
import org.drools.event.BeforeRuleBaseUnlockedEvent;
import org.drools.event.BeforeRuleRemovedEvent;
import org.drools.event.RuleBaseEventListener;
import org.drools.rule.Package;
import org.drools.rule.Rule;

public class RuleBaseEventSupport
implements Serializable {
    private static final long serialVersionUID = 400L;
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private transient RuleBase ruleBase;

    public RuleBaseEventSupport(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void addEventListener(RuleBaseEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void removeEventListener(Class cls) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            EventListener listener = (EventListener)it.next();
            if (!cls.isAssignableFrom(listener.getClass())) continue;
            it.remove();
        }
    }

    public void removeEventListener(RuleBaseEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireBeforePackageAdded(Package newPkg) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforePackageAddedEvent event = new BeforePackageAddedEvent(this.ruleBase, newPkg);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforePackageAdded(event);
        }
    }

    public void fireAfterPackageAdded(Package newPkg) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterPackageAddedEvent event = new AfterPackageAddedEvent(this.ruleBase, newPkg);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterPackageAdded(event);
        }
    }

    public void fireBeforePackageRemoved(Package pkg) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforePackageRemovedEvent event = new BeforePackageRemovedEvent(this.ruleBase, pkg);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforePackageRemoved(event);
        }
    }

    public void fireAfterPackageRemoved(Package pkg) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterPackageRemovedEvent event = new AfterPackageRemovedEvent(this.ruleBase, pkg);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterPackageRemoved(event);
        }
    }

    public void fireBeforeRuleBaseLocked() {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeRuleBaseLockedEvent event = new BeforeRuleBaseLockedEvent(this.ruleBase);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforeRuleBaseLocked(event);
        }
    }

    public void fireAfterRuleBaseLocked() {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterRuleBaseLockedEvent event = new AfterRuleBaseLockedEvent(this.ruleBase);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterRuleBaseLocked(event);
        }
    }

    public void fireBeforeRuleBaseUnlocked() {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeRuleBaseUnlockedEvent event = new BeforeRuleBaseUnlockedEvent(this.ruleBase);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforeRuleBaseUnlocked(event);
        }
    }

    public void fireAfterRuleBaseUnlocked() {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterRuleBaseUnlockedEvent event = new AfterRuleBaseUnlockedEvent(this.ruleBase);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterRuleBaseUnlocked(event);
        }
    }

    public void fireBeforeRuleAdded(Package newPkg, Rule rule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeRuleAddedEvent event = new BeforeRuleAddedEvent(this.ruleBase, newPkg, rule);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforeRuleAdded(event);
        }
    }

    public void fireAfterRuleAdded(Package newPkg, Rule rule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterRuleAddedEvent event = new AfterRuleAddedEvent(this.ruleBase, newPkg, rule);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterRuleAdded(event);
        }
    }

    public void fireBeforeRuleRemoved(Package pkg, Rule rule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeRuleRemovedEvent event = new BeforeRuleRemovedEvent(this.ruleBase, pkg, rule);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforeRuleRemoved(event);
        }
    }

    public void fireAfterRuleRemoved(Package pkg, Rule rule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterRuleRemovedEvent event = new AfterRuleRemovedEvent(this.ruleBase, pkg, rule);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterRuleRemoved(event);
        }
    }

    public void fireBeforeFunctionRemoved(Package pkg, String function) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeFunctionRemovedEvent event = new BeforeFunctionRemovedEvent(this.ruleBase, pkg, function);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).beforeFunctionRemoved(event);
        }
    }

    public void fireAfterFunctionRemoved(Package pkg, String function) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterFunctionRemovedEvent event = new AfterFunctionRemovedEvent(this.ruleBase, pkg, function);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleBaseEventListener)this.listeners.get(i)).afterFunctionRemoved(event);
        }
    }
}

