/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.drools.RuntimeDroolsException;
import org.drools.spi.FieldValue;

public class ObjectFieldImpl
implements FieldValue {
    private static final long serialVersionUID = 400L;
    private final Object value;
    private final boolean isCollection;
    private final boolean isNumber;
    private final boolean isBoolean;
    private final boolean isCharacter;
    private final boolean isString;

    public ObjectFieldImpl(Object value) {
        this.value = value;
        this.isCollection = value instanceof Collection;
        this.isNumber = value instanceof Number;
        this.isBoolean = value instanceof Boolean;
        this.isCharacter = value instanceof Character;
        this.isString = value instanceof String;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public boolean getBooleanValue() {
        if (this.isBoolean) {
            return (Boolean)this.value;
        }
        if (this.isString) {
            return Boolean.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to boolean not supported for type: " + this.value.getClass());
    }

    public byte getByteValue() {
        if (this.isNumber) {
            return ((Number)this.value).byteValue();
        }
        if (this.isString) {
            return Byte.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to byte not supported for type: " + this.value.getClass());
    }

    public char getCharValue() {
        if (this.isCharacter) {
            return ((Character)this.value).charValue();
        }
        if (this.isString && ((String)this.value).length() == 1) {
            return ((String)this.value).charAt(0);
        }
        throw new RuntimeDroolsException("Conversion to char not supported for type: " + this.value.getClass());
    }

    public double getDoubleValue() {
        if (this.isNumber) {
            return ((Number)this.value).doubleValue();
        }
        if (this.isString) {
            return Double.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to double not supported for type: " + this.value.getClass());
    }

    public float getFloatValue() {
        if (this.isNumber) {
            return ((Number)this.value).floatValue();
        }
        if (this.isString) {
            return Float.valueOf((String)this.value).floatValue();
        }
        throw new RuntimeDroolsException("Conversion to float not supported for type: " + this.value.getClass());
    }

    public int getIntValue() {
        if (this.isNumber) {
            return ((Number)this.value).intValue();
        }
        if (this.isString) {
            return Integer.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to int not supported for type: " + this.value.getClass());
    }

    public long getLongValue() {
        if (this.isNumber) {
            return ((Number)this.value).longValue();
        }
        if (this.isString) {
            return Long.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to long not supported for type: " + this.value.getClass());
    }

    public short getShortValue() {
        if (this.isNumber) {
            return ((Number)this.value).shortValue();
        }
        if (this.isString) {
            return Short.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to short not supported for type: " + this.value.getClass());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectFieldImpl)) {
            return false;
        }
        ObjectFieldImpl other = (ObjectFieldImpl)object;
        return this.value == null && other.value == null || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isBooleanField() {
        return false;
    }

    public boolean isFloatNumberField() {
        return false;
    }

    public boolean isIntegerNumberField() {
        return false;
    }

    public boolean isObjectField() {
        return true;
    }

    public boolean isCollectionField() {
        return this.isCollection;
    }

    public boolean isStringField() {
        return this.isString;
    }

    public BigDecimal getBigDecimalValue() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.isNumber) {
            return new BigDecimal(((Number)this.value).doubleValue());
        }
        if (this.isString) {
            return new BigDecimal((String)this.value);
        }
        if (this.value == null) {
            return null;
        }
        throw new RuntimeDroolsException("Conversion to BigDecimal not supported for type: " + this.value.getClass());
    }

    public BigInteger getBigIntegerValue() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.isNumber) {
            return BigInteger.valueOf(((Number)this.value).longValue());
        }
        if (this.isString) {
            return new BigInteger((String)this.value);
        }
        if (this.value == null) {
            return null;
        }
        throw new RuntimeDroolsException("Conversion to BigInteger not supported for type: " + this.value.getClass());
    }
}

