/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.util.Properties;
import org.drools.agent.FileScanner;
import org.drools.agent.PackageProvider;
import org.drools.rule.Package;

public class DirectoryScanner
extends PackageProvider {
    private File[] currentList;
    private FileScanner scanner;
    private File dir;

    void configure(Properties config) {
        String d = config.getProperty("dir");
        this.dir = new File(d);
        if (!this.dir.isDirectory() || !this.dir.exists()) {
            throw new IllegalArgumentException("The directory " + d + "is not valid.");
        }
        this.currentList = this.dir.listFiles();
        this.scanner = new FileScanner();
        this.scanner.setFiles(this.currentList);
    }

    Package[] loadPackageChanges() {
        if (this.currentList.length != this.dir.listFiles().length) {
            this.listener.info("Extra files detected in the directory " + this.dir.getPath());
            this.currentList = this.dir.listFiles();
            this.scanner = new FileScanner();
            this.scanner.setFiles(this.currentList);
        }
        return this.scanner.loadPackageChanges();
    }

    public String toString() {
        String s = "DirectoryScanner";
        if (this.dir != null) {
            s = s + " scanning dir: " + this.dir.getPath();
        }
        if (this.currentList != null) {
            s = s + " found " + this.currentList.length + " file(s).";
        }
        return s;
    }
}

