package org.jboss.seam.test.unit;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.IntegerConverter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.navigation.Param;
import org.testng.annotations.Test;

public class PageParamTest extends AbstractPageTest
{
   @Test
   public void testGetConverterById()
   {
      String converterId = "javax.faces.Integer";
      String converterClass = "javax.faces.convert.IntegerConverter";
      MockFacesContext facesContext = new MockFacesContext(new MockExternalContext(), new MockApplication());
      facesContext.setCurrent();
      Param param = new Param("param");
      param.setConverterId(converterId);
      assert param.getConverter() instanceof IntegerConverter : "expecting: " + converterClass + "; got: " + param.getConverter();
   }
   
   @Test
   public void testGetValidatorById() throws ClassNotFoundException
   {
      String validatorId = "TestValidator";
      String validatorClass= "org.jboss.seam.test.unit.PageParamTest$TestValidator";
      MockFacesContext facesContext = new MockFacesContext(new MockExternalContext(), new MockApplication());
      facesContext.setCurrent();
      facesContext.getApplication().addValidator(validatorId, validatorClass);
      Param param = new Param("param");
      param.setValidatorId(validatorId);
      assert param.getValidator() instanceof TestValidator : "expecting: " + validatorClass + "; got: " + param.getValidator();
   }
   
   /**
    * Verify EL expression disability in actionOutcome parameter
    */
   @Test(expectedExceptions = IllegalArgumentException.class )
   public void testGetCallAction()
   {
      EnhancedMockHttpServletRequest request = new EnhancedMockHttpServletRequest();
      request.addParameter("actionOutcome", "#{variable}");
      FacesContext.getCurrentInstance().getExternalContext().setRequest(request);
      Pages.instance().preRender(FacesContext.getCurrentInstance());      
   }
   
   @Test(expectedExceptions = IllegalArgumentException.class )
   public void testGetCallActionEscaped()
   {
      EnhancedMockHttpServletRequest request = new EnhancedMockHttpServletRequest();
      request.addParameter("actionOutcome", "%3d%23%7dvariable%7b");
      FacesContext.getCurrentInstance().getExternalContext().setRequest(request);
      Pages.instance().preRender(FacesContext.getCurrentInstance());      
   }
   
   public static class TestValidator implements Validator
   {
      public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException
      {
      }
      
   }
}
