/*
* JBoss, Home of Professional Open Source
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.seam.annotations;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.jboss.seam.ScopeType;

/**
 * Specifies the scope (context) of a seam component.
 *
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @version $Revision: 1423 $
 */
@Target(TYPE)
@Retention(RUNTIME)
@Documented
@Inherited
public @interface Scope {
   ScopeType value();
}


