/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009 Red Hat Middleware, Inc. and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.scripts.test;

import java.io.File ;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.test.JBossTestSetup ;

/**
 * Unit tests of probe.sh and probe.bat.
 * 
 * Requires testing against the all config.
 * 
 * There are a number of tests which need covering and their priority:
 * (high) - that we get at least 4 responses (for the four channels in the AS) [DONE]
 * (high) - that -match Tomcat-Cluster returns only one response (need isolation, need negative assertion) [DONE]
 * (low)  - that -addr and -port when used in conjunction with server which has had 
 * its diagnostics address and port changed returns exactly 4 replies
 * 
 * @author Richard Achmatowicz
 * @version $Revision: $
 */
public class ProbeTestCase extends ScriptsTestBase
{
   /**
    * Create a new ProbeTestCase.
    * 
    * @param name
    */
   public ProbeTestCase(String name)
   {
      super(name);      
   }
   
   /**
    * Prints out some basic info about the environment 
    */
   public void testExecutionEnvironment() {
	   String os = isWindows() ? "Windows" : "non-Windows" ;
	     
	   // dump out some basic config information
	   System.out.println("\nTesting probe on " + os + " host") ;
	   System.out.println("Working directory: " + getBinDir()) ;
	   System.out.println("Dist directory: " + getDistDir()) ;	   
   }
   
   /**
    * Tests probe "help" command 
    *  
    * @throws Exception
    */
   public void testNoArgs() throws Exception
   {
	   // build the shell command to execute
	   // supply the command name prefix, any options as a string, and any args
	   String command = "probe" ;
	   String options = null ;  
	   String args = "-help" ;
	   String[] shellCommand = getShellCommand(command, options, args) ;
	   
	   // set the environment if necessary 
	   String[] envp = null ;
	   // set the working directory
	   File workingDir = new File(getBinDir()) ;

	   // execute command
	   getShellScriptExecutor().runShellCommand(shellCommand, envp, workingDir) ; 

	   // check assertions
	   getShellScriptExecutor().assertOnOutputStream("Probe [-help]","Usage string not found in command output") ;
   }  

   /**
    * Tests probe receives a response for every channel in the AS 
    *  
    * @throws Exception
    */
   public void testResponseSet() throws Exception
   {
	   // build the shell command to execute
	   // supply the command name prefix, any options as a string, and any args
	   String command = "probe" ;
	   String options = null ;  
	   String args = null ;
	   String[] shellCommand = getShellCommand(command, options, args) ;
	   
	   // set the environment if necessary 
	   String[] envp = null ;
	   // set the working directory
	   File workingDir = new File(getBinDir()) ;

	   // execute command
	   getShellScriptExecutor().runShellCommand(shellCommand, envp, workingDir) ; 

	   // check assertions
	   getShellScriptExecutor().assertOnOutputStream("#4","Less than 4 channel responses found in command output") ;
	   getShellScriptExecutor().assertOnOutputStream("DefaultPartition-SFSBCache","DefaultPartition-SFSBCache channel response not found in command output") ;
	   getShellScriptExecutor().assertOnOutputStream("DefaultPartition-EntityCache","DefaultPartition-EntityCache channel response not found in command output") ;
	   getShellScriptExecutor().assertOnOutputStream("DefaultPartition","DefaultPartition channel response not found in command output") ;
	   getShellScriptExecutor().assertOnOutputStream("Tomcat-Cluster","Tomcat-Cluster channel response not found in command output") ;
   }  
   
   
   /**
    * Tests probe -query jmx command (returns a list of JMX statistics for each protocol)
    *  
    * @throws Exception
    */
   public void testQueryJMX() throws Exception
   {
	   // build the shell command to execute
	   // supply the command name prefix, any options as a string, and any args
	   String command = "probe" ;
	   String options = null ;  
	   String args = "-query jmx" ;
	   String[] shellCommand = getShellCommand(command, options, args) ;
	   
	   // set the environment if necessary 
	   String[] envp = null ;
	   // set the working directory
	   File workingDir = new File(getBinDir()) ;

	   // execute command
	   getShellScriptExecutor().runShellCommand(shellCommand, envp, workingDir) ; 

	   // check assertions
	   getShellScriptExecutor().assertOnOutputStream("stats:","'stats:' string not found in command output") ;
   }  
   
   /**
    * Tests probe -query props command (returns the stack used by each channel)
    *  
    * @throws Exception
    */
   public void testQueryProps() throws Exception
   {
	   // build the shell command to execute
	   // supply the command name prefix, any options as a string, and any args
	   String command = "probe" ;
	   String options = null ;  
	   String args = "-query props" ;
	   String[] shellCommand = getShellCommand(command, options, args) ;
	   
	   // set the environment if necessary 
	   String[] envp = null ;
	   // set the working directory
	   File workingDir = new File(getBinDir()) ;

	   // execute command
	   getShellScriptExecutor().runShellCommand(shellCommand, envp, workingDir) ; 

	   // check assertions
	   getShellScriptExecutor().assertOnOutputStream("props:","'props:' string not found in command output") ;
   }  
   
   /**
    * Tests probe -match command (returns only responses containing the match text)
    *  
    * @throws Exception
    */
   public void testQueryMatch() throws Exception
   {
	   // build the shell command to execute
	   // supply the command name prefix, any options as a string, and any args
	   String command = "probe" ;
	   String options = null ;  
	   String args = "-match Tomcat-Cluster" ;
	   String[] shellCommand = getShellCommand(command, options, args) ;
	   
	   // set the environment if necessary 
	   String[] envp = null ;
	   // set the working directory
	   File workingDir = new File(getBinDir()) ;

	   // execute command
	   getShellScriptExecutor().runShellCommand(shellCommand, envp, workingDir) ; 

	   // check assertions
	   // need to check the absence of a string here!
	   // assertNotOnOutputStream("Default-Partition", "'Default-Partition' found in match list")
	   getShellScriptExecutor().assertOnOutputStream("Tomcat-Cluster","'Tomcat-Cluster' string not found in command output") ;
   }  
  
   /* 
    * one time setup mechamism
    * only good for static stuff
    *  
   public static Test suite() throws Exception
   {
	   TestSuite suite = new TestSuite();
	   suite.addTest(new TestSuite(TwiddleTestCase.class));
	   
	   JBossTestSetup setup = new JBossTestSetup(suite) {
		   
           protected void setUp() throws Exception {
           }
           
           protected void tearDown() throws Exception {
        	   
           }
	   } ;
      return setup ;
   }
   */
}
