/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.jca.inflow;

import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;

/**
 * Management interface of TestResourceAdapter.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 57211 $
 */
public class TestResourceAdapterWorkManagerTxTimeout
{
   TestResourceAdapter adapter;
   public TestResourceAdapterWorkManagerTxTimeout(TestResourceAdapter adapter)
   {
      this.adapter = adapter;
   }
   
   public TestResourceAdapterWorkManagerTxTimeoutResults run() throws Exception
   {
      TestResourceAdapterWorkManagerTxTimeoutResults results = new TestResourceAdapterWorkManagerTxTimeoutResults();
      try
      {
         basicTest();
         results.basicTest.pass();
      }
      catch (Throwable t)
      {
         results.basicTest.fail(t);
      }

      return results;
   }
   
   public void basicTest() throws Exception
   {
      WorkManager wm = adapter.ctx.getWorkManager();
      TestWork work = new TestWork(); 
      ExecutionContext ctx = new ExecutionContext();
      long timeoutSeconds=3;
      long expectedTimeoutMillis=3*1000;
      ctx.setTransactionTimeout(timeoutSeconds);
      
      long startTime=System.currentTimeMillis();
      wm.doWork(work, 0l, ctx, null);
      long totaltime = work.completionTime - startTime;
      if (work.complete == false)
      {
    	  throw new Exception("The work was not inturrupted properly.  The worker thread was supposed to be inturrupted within 3000(ms) and was not after waiting 5000(ms)"); 
      }
      else
      {
    	  if(totaltime<expectedTimeoutMillis)
    		  throw new Exception("The work was inturrupted too soon.  TotalTime(ms)="+totaltime+" expected time(ms)="+expectedTimeoutMillis);
      }
      
      
   }
   
   public class TestWork implements Work
   {
      public boolean complete = false;
      public long completionTime;
      public Object lockObject = new Object();
      public void run()
      {
          
    	  System.out.println("Curent thread is "+Thread.currentThread());
          synchronized(lockObject)
          {
        	  try 
        	  {
				//wait for 5 seconds.  If the thread pool doesn't inturrupt us, then we have a problem
        		  lockObject.wait(5000);
			  } 
        	  catch (InterruptedException e) 
			  {
				//We SHOULD be interrupted in this test.  If we are not interrupted, we didn't complete properly.
				complete=true;
			  }
          }
          completionTime = System.currentTimeMillis();
      }

      public void release()
      {

      }
   }
}
