/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp933.unit;

import javax.naming.NameNotFoundException;

import junit.framework.Test;

import org.jboss.ejb3.test.jbpapp933.ejb2.SLSB21Test;
import org.jboss.ejb3.test.jbpapp933.ejb2.SLSB21TestHome;
import org.jboss.ejb3.test.jbpapp933.ejb3.TestServiceRemote;
import org.jboss.test.JBossTestCase;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class JavaENCUnitTestCase extends JBossTestCase
{
   /**
    * @param name
    */
   public JavaENCUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * java:comp/env/SLSB21TestEJB has been bound to different entries, let's see.
    */
   public void testOverlap1() throws Exception
   {
      SLSB21TestHome home = (SLSB21TestHome) getInitialContext().lookup("SLSB21Test");
      SLSB21Test bean = home.create();
      String actual = bean.getDescription();
      assertEquals("number 1", actual);
   }
   
   public void testOverlap2() throws Exception
   {
      try
      {
         SLSB21TestHome home = (SLSB21TestHome) getInitialContext().lookup("SLSB21Test2");
         SLSB21Test bean = home.create();
         String actual = bean.getDescription();
         assertEquals("number 2", actual);
      }
      catch(NameNotFoundException e)
      {
         // if we can't find SLSB21Test2 then the test has failed,
         // because the most likely cause is java:comp/env already bound.
         fail(e.getMessage());
      }
   }
   
   public void testService() throws Exception
   {
      TestServiceRemote bean = (TestServiceRemote) getInitialContext().lookup("jbpapp933/TestServiceBean/remote");
      assertTrue(bean.hasStarted());
   }
   
   public void testServerFound() throws Exception
   {
      serverFound();
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(JavaENCUnitTestCase.class, "jbpapp933.ear");
   }
}
