/*
 * JBoss, Home of Professional Open Source
 * Copyright (c) 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp2811;

import org.jboss.logging.Logger;

import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author <a href="cdewolf@redhat.com">Carlo de Wolf</a>
 */
@Stateless
public class TimerTaskBean implements TimerTaskRemote
{
   private static final Logger log = Logger.getLogger(TimerTaskBean.class);
   
   // これは不適当である。
   private static AtomicInteger timeouts = new AtomicInteger(0);

   @Resource
   private SessionContext ctx;

   @Resource
   private TimerService timerService;

   public int getTimeouts()
   {
      return timeouts.intValue();
   }

   public void startTask(long timeout)
   {
      // たった一度だけ行う。
      timerService.createTimer(timeout, new Date());
   }

   @Timeout
   public void timeout(Timer timer)
   {
      log.info("timeout " + timer);
      
      timeouts.incrementAndGet();

      // 常にロールバック。
      ctx.setRollbackOnly();
   }
}
