/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp2290;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

import org.jboss.logging.Logger;

/**
 * ImplementsSessionSynchronizationBean
 * 
 * A test SFSB that directly implements SessionSynchronization
 * 
 * JBPAPP-2290 (incorporates EJBTHREE-995)
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @author <a href="mailto:tkobayas@redhat.com">Toshiya Kobayashi</a>
 * @version $Revision: 102090 $
 */
@Stateful
@Remote(ImplementsSessionSynchronizationRemoteBusiness.class)
public class ImplementsSessionSynchronizationBean
      implements
         ImplementsSessionSynchronizationRemoteBusiness,
         SessionSynchronization
{

   // --------------------------------------------------------------------------------||
   // Class Members ------------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   private static final Logger log = Logger.getLogger(ImplementsSessionSynchronizationBean.class);

   /*
    * Define some counters to be used by the test.
    */
   public int CALLS_AFTER_BEGIN = 0;

   public int CALLS_AFTER_COMPLETION = 0;

   public int CALLS_BEFORE_COMPLETION = 0;

   // --------------------------------------------------------------------------------||
   // Required Implementations -------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   /**
    * A simple invocation that implements no business logic
    */
   @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
   public void call()
   {
   }

   public void afterBegin() throws EJBException, RemoteException
   {
      log.info("afterBegin");
      CALLS_AFTER_BEGIN++;
   }

   public void afterCompletion(boolean committed) throws EJBException, RemoteException
   {
      log.info("afterCompletion");
      CALLS_AFTER_COMPLETION++;
   }

   public void beforeCompletion() throws EJBException, RemoteException
   {
      log.info("beforeCompletion");
      CALLS_BEFORE_COMPLETION++;
   }

   // --------------------------------------------------------------------------------||
   // Helper Methods -----------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   /**
    * Resets the SessionSynchronization counters
    */
   @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
   public void resetCounters()
   {
      CALLS_AFTER_BEGIN = 0;
      CALLS_AFTER_COMPLETION = 0;
      CALLS_BEFORE_COMPLETION = 0;
   }

   @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
   public int getCounterAfterBegin() {
      return CALLS_AFTER_BEGIN;
   }

   @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
   public int getCounterAfterCompletion() {
      return CALLS_AFTER_COMPLETION;
   }

   @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
   public int getCounterBeforeCompletion() {
      return CALLS_BEFORE_COMPLETION;
   }

}
