/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1951.unit;

import java.io.Serializable;

import javax.jms.DeliveryMode;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;

import junit.framework.Test;

import org.jboss.ejb3.test.common.EJB3TestCase;

/**
 * Case #287560
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class CallerPrincipalTestCase extends EJB3TestCase
{
   public CallerPrincipalTestCase(String name)
   {
      super(name);
   }
   
   public String sendMessage(String queueName, String text) throws Exception
   {
      Queue queue = lookup("queue/" + queueName, Queue.class);
      QueueConnectionFactory factory = getQueueConnectionFactory();
      QueueConnection conn = factory.createQueueConnection();
      try
      {
         QueueSession session = conn.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
         TemporaryQueue replyQueue = session.createTemporaryQueue();
         QueueReceiver receiver = session.createReceiver(replyQueue);
         QueueSender sender = session.createSender(queue);
         conn.start();
         try
         {
            TextMessage msg = session.createTextMessage(text);
            msg.setJMSReplyTo(replyQueue);
            msg.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
            msg.setIntProperty("JMS_JBOSS_REDELIVERY_LIMIT", 1);
      
            sender.send(msg);
            
            Message reply = receiver.receive(5000);
            assertNotNull(reply);
            
            Serializable obj = ((ObjectMessage) reply).getObject();
            if(obj instanceof String)
            {
               String result = (String) obj;
               return result;
            }
            else if(obj instanceof Exception)
               throw (Exception) obj;
            else
               throw new IllegalArgumentException(obj.toString());
         }
         finally
         {
            conn.stop();
            sender.close();
            receiver.close();
            session.close();
         }
      }
      finally
      {
         conn.close();
      }
   }
   
   public void testAnonymous() throws Exception
   {
      String result = sendMessage("Anonymous", "Knock knock");
      assertEquals("anonymous: Knock knock: false", result);
   }
   
   public void testRunAsRoot() throws Exception
   {
      String result = sendMessage("RunAsRoot", "Who's there?");
      assertEquals("root-principal: Who's there?: true", result);
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(CallerPrincipalTestCase.class, "jbpapp1951.jar");
   }
}
