/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1668;

import javax.annotation.Resource;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.jboss.ejb3.test.common.AbstractReplierMDB;
import org.jboss.logging.Logger;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public abstract class AbstractTXMDB extends AbstractReplierMDB
{
   private static final Logger log = Logger.getLogger(AbstractTXMDB.class);
   
   // this goes against spec, normally you would use BMT and UserTransaction
   @Resource(mappedName="java:/TransactionManager")
   private TransactionManager tm;
   
   protected void process(Message message)
   {
      try
      {
         Destination destination = message.getJMSReplyTo();
         
         try
         {
            int status = tm.getStatus();
            
            log.info("Transaction status for " + this + " is " + status);
            
            sendReply(destination, status);
         }
         catch(SystemException e)
         {
            log.warn("Transaction status for " + this + " failed", e);
            sendReply(destination, e);
         }
      }
      catch(JMSException e)
      {
         throw new RuntimeException(e);
      }
   }
}
