/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1307.unit;

import java.util.List;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.ejb3.test.jbpapp1224.DefaultedServiceRemote;
import org.jboss.ejb3.test.jbpapp1224.unit.DefaultedMBeanUnitTestCase;
import org.jboss.ejb3.test.jbpapp1307.Entity1;
import org.jboss.ejb3.test.jbpapp1307.SLSBRemote;
import org.jboss.test.JBossTestCase;

/**
 * NestedJarInPersistenceUnitTestCase
 * 
 * Tests that if a persistence unit jar contains a nested jar, then the
 * deployment works successfully and the persistence unit is usable.
 * This is related to https://jira.jboss.org/jira/browse/JBPAPP-1307
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class NestedJarInPersistenceUnitTestCase extends JBossTestCase
{

   /**
    * Constructor
    * @param name
    */
   public NestedJarInPersistenceUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * Test that the deployment of a persistence unit jar with a nested 
    * jar works successfully and operations on the persistence unit
    * work as expected
    * 
    * @throws Exception
    */
   public void testPersistenceUnitDeployment() throws Exception
   {
      SLSBRemote bean = (SLSBRemote) getInitialContext().lookup(SLSBRemote.JNDI_NAME);
      String data = "testOne";
      bean.createNewEntity("testOne");
      List<Entity1> entities = bean.getAllEntities();
      assertNotNull("Entities list was null", entities);
      assertEquals("Unexpected number of entities returned", 1, entities.size());
      Entity1 entity = entities.get(0);
      assertEquals("Unexpected entity returned", data, entity.getData());
      
   }
   
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(NestedJarInPersistenceUnitTestCase.class, "jbpapp1307.jar");
   }
}
