/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1186.unit;

import javax.naming.NamingException;

import junit.framework.Test;

import org.jboss.ejb3.test.jbpapp1186.AnInterface;
import org.jboss.ejb3.test.jbpapp1186.ControlInterface;
import org.jboss.test.JBossTestCase;

/**
 * Calling a remove method withing a transaction must not result
 * in multiple pre-destroy calls.
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class MultiplePreDestroyUnitTestCase extends JBossTestCase
{
   private ControlInterface control;

   public MultiplePreDestroyUnitTestCase(String name)
   {
      super(name);
   }

   public void test1() throws NamingException
   {
      assertEquals(0, control.count());
      AnInterface intf1 = control.initialInterface();
      intf1.getAnInterface();
      assertEquals(2, control.count());
      control.discardAll();
      control.clearAll();
      
      assertEquals(0, control.failures());
   }
   
   public void test2()
   {
      assertEquals(0, control.count());
      AnInterface intf1 = control.initialInterface();
      AnInterface intf2 = intf1.getAnInterface();
      assertEquals(2, control.count());
      intf1.discard();
      intf2.discard();    
      control.clearAll();
      
      assertEquals(0, control.failures());
   }
   
   @Override
   protected void setUp() throws Exception
   {
      super.setUp();
      
      control = (ControlInterface) getInitialContext().lookup("ControlImpl/remote");
      control.resetFailures();
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(MultiplePreDestroyUnitTestCase.class, "jbpapp1186.jar");
   }
}
