/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.ejbthree1358.unit;

import javax.ejb.EJBException;

import junit.framework.Test;

import org.jboss.ejb3.test.common.EJB3TestCase;
import org.jboss.ejb3.test.ejbthree1358.Lektorat;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class PoolUsageTestCase extends EJB3TestCase
{
   public PoolUsageTestCase(String name)
   {
      super(name);
   }

   public void test1() throws Exception
   {
      Lektorat beans[] = new Lektorat[10];
      for(int i = 0; i < beans.length; i++)
      {
         beans[i] = lookup("Lektorat/remote", Lektorat.class);
         // 4.x constructs at first call
         beans[i].setName("Bean " + i);
      }
      
      try
      {
         Lektorat bean = lookup("Lektorat/remote", Lektorat.class);
         bean.setName("Fails");
         fail("Expected EJBException");
      }
      catch(EJBException e)
      {
         // good
      }
   }
   
   public void test2() throws Exception
   {
      Lektorat beans[] = new Lektorat[10];
      for(int i = 0; i < beans.length; i++)
      {
         beans[i] = lookup("Lektorat/remote", Lektorat.class);
         // 4.x constructs at first call
         beans[i].setName("Bean " + i);
      }
      
      beans[0].delete();
      
      try
      {
         Lektorat bean = lookup("Lektorat/remote", Lektorat.class);
         bean.setName("Replace Bean 0");
      }
      catch(EJBException e)
      {
         fail(e.getMessage());
      }
   }
   
   @Override
   protected void tearDown() throws Exception
   {
      // TODO: remove, but as long as the bug is in there we can't reuse the pool
      redeploy("ejbthree1358.jar");
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(PoolUsageTestCase.class, "ejbthree1358.jar");
   }
}
