package org.jboss.ejb3.timer;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.tm.TransactionManagerLocator;

import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/**
 * Make sure we register a timer into the current transaction.
 * 
 * @author <a href="cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class TimerTxRegistrationInterceptor extends AbstractInterceptor
{
   private TransactionManager tm;

   public TimerTxRegistrationInterceptor()
   {
      tm = TransactionManagerLocator.getInstance().locate();
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      return invoke((EJBContainerInvocation) invocation);
   }

   public Object invoke(EJBContainerInvocation invocation) throws Throwable
   {
      Transaction tx = tm.getTransaction();
      Timer timer = invocation.getTimer();
      if(tx != null && (timer instanceof Synchronization))
         tx.registerSynchronization((Synchronization) timer);
      return invocation.invokeNext();
   }
}
