if (!window.Richfaces) {
	window.Richfaces = {};
}

Richfaces.getComputedStyle = function(eltId, propertyName) {
	var elt = $(eltId);
	if (elt.currentStyle) {
		return elt.currentStyle[propertyName];
	}

	if (document.defaultView && document.defaultView.getComputedStyle &&
		document.defaultView.getComputedStyle(elt, null)) {
		return document.defaultView.getComputedStyle(elt, null).getPropertyValue(propertyName);
	}

	return "";
};

Richfaces.getComputedStyleSize = function(eltId, propertyName) {
	var value = Richfaces.getComputedStyle(eltId, propertyName);

	if (value) {
		value = value.strip();	
		value = value.replace(/px$/, "");
		
		return parseFloat(value);
	}
	
	return 0;
};

Richfaces.getWindowSize = function() {
    var myWidth = 0, myHeight = 0;
    if( typeof( window.innerWidth ) == 'number' ) {
        myWidth = window.innerWidth;
        myHeight = window.innerHeight;
    } else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
        myWidth = document.documentElement.clientWidth;
        myHeight = document.documentElement.clientHeight;
    } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
        myWidth = document.body.clientWidth;
        myHeight = document.body.clientHeight;
    }
	return {"width":myWidth,"height":myHeight};
};

Richfaces.removePX = function(str) {
	var pxIndex = str.indexOf("px")
	if ( pxIndex == -1 ) return str;
	return str.substr(0,pxIndex);
};

Richfaces.isNodeInDOMTree = function(node) {
	var root = document.documentElement;
	var elt = node;
	while (elt && elt != root) {
		elt = elt.parentNode;
	}

	return !!elt;
};

Richfaces.visitTree = function(root, callback) {
	var node = root;
	if (!node) {
		node = document;
	}
	
	callback.call(this, node);
	
	var children = node.childNodes;
	for (var i = 0; i < children.length; i++ ) {
		Richfaces.visitTree(children[i], callback);
	}
};

Richfaces.getNSAttribute = function (name, element) {
	if (element.getAttributeNS) {
		var attr = element.getAttributeNS('http://richfaces.ajax4jsf.org/rich', name);
		if (attr) {
			return attr;
		}
	} 
	
	var attrName = "rich:" + name;
	
	var attr = element.attributes[attrName];
	if (attr) {
		return attr.nodeValue;
	}

	var attributes = element.attributes;
	for (var i = 0; i < attributes.length; i++) {
		attr = attributes[i];
		if (attr && attrName == attr.nodeName) {
			return attr.nodeValue;
		}
	}	

	return null;
};