/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

class NumericTranslator
extends BinaryDataTranslator {
    private int frac;
    private static DecimalFormat doubleInputFormat;

    protected NumericTranslator(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n6, n7);
        switch (n3) {
            case 1: 
            case 12: {
                n5 = 38;
            }
        }
        this.frac = n5;
    }

    public BigDecimal getBigDecimal(int n, SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        BigDecimal bigDecimal = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            bigDecimal = VDNNumber.number2BigDecimal(structuredMem.getBytes(this.bufpos, this.physicalLength - 1), n);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        BigDecimal bigDecimal = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            bigDecimal = VDNNumber.number2BigDecimal(structuredMem.getBytes(this.bufpos, this.physicalLength - 1), this.frac);
        }
        return bigDecimal;
    }

    private BigDecimal getBigDecimalWithoutScale(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        BigDecimal bigDecimal = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            bigDecimal = VDNNumber.number2BigDecimal(structuredMem.getBytes(this.bufpos, this.physicalLength - 1));
        }
        return bigDecimal;
    }

    public boolean getBoolean(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        int n = this.getInt(sQLParamController, structuredMem);
        return n != 0;
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return (byte)this.getLong(sQLParamController, structuredMem);
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Double(this.getBigDecimalWithoutScale(sQLParamController, structuredMem));
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Float(this.getBigDecimalWithoutScale(sQLParamController, structuredMem));
    }

    public int getInt(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return (int)this.getLong(sQLParamController, structuredMem);
    }

    public long getLong(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        long l = 0L;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            l = VDNNumber.number2long(byArray);
        }
        return l;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        if (this.isNull(sQLParamController, structuredMem)) {
            return null;
        }
        switch (this.dataType) {
            case 1: {
                if (this.logicalLength < 15) {
                    return new Float(this.getFloat(sQLParamController, structuredMem));
                }
                if (this.logicalLength < 16) {
                    return new Double(Float.toString(this.getFloat(sQLParamController, structuredMem)));
                }
                return new Double(this.getDouble(sQLParamController, structuredMem));
            }
        }
        return this.getBigDecimal(sQLParamController, structuredMem);
    }

    public int getPrecision() {
        int n;
        switch (this.dataType) {
            case 0: {
                n = this.logicalLength;
                break;
            }
            default: {
                n = this.logicalLength;
            }
        }
        return n;
    }

    public int getScale() {
        int n;
        switch (this.dataType) {
            case 0: {
                n = this.frac;
                break;
            }
            case 29: 
            case 30: {
                n = 0;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public short getShort(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return (short)this.getLong(sQLParamController, structuredMem);
    }

    public Object transBigDecimalForInput(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        bigDecimal.setScale(this.frac, 5);
        byte[] byArray = VDNNumber.bigDecimal2number(bigDecimal);
        return byArray;
    }

    public Object transDoubleForInput(double d) throws SQLException {
        BigDecimal bigDecimal = new BigDecimal(doubleInputFormat.format(d));
        if (this.dataType == 0) {
            bigDecimal = bigDecimal.setScale(this.frac, 5);
        }
        byte[] byArray = VDNNumber.bigDecimal2number(bigDecimal, 16);
        return byArray;
    }

    public Object transFloatForInput(float f) throws SQLException {
        BigDecimal bigDecimal = new BigDecimal(doubleInputFormat.format(f));
        if (this.dataType == 0) {
            bigDecimal = bigDecimal.setScale(this.frac, 5);
        }
        byte[] byArray = VDNNumber.bigDecimal2number(bigDecimal, 14);
        return byArray;
    }

    public Object transIntForInput(int n) throws SQLException {
        byte[] byArray = VDNNumber.long2number(n);
        return byArray;
    }

    public Object transLongForInput(long l) throws SQLException {
        byte[] byArray = VDNNumber.long2number(l);
        return byArray;
    }

    public Object transShortForInput(short s) throws SQLException {
        byte[] byArray = VDNNumber.long2number(s);
        return byArray;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            object2 = this.transBigDecimalForInput((BigDecimal)object);
        } else if (object instanceof Boolean) {
            object2 = this.transBooleanForInput((Boolean)object);
        } else if (object instanceof Byte) {
            object2 = this.transByteForInput((Byte)object);
        } else if (object instanceof Double) {
            object2 = this.transDoubleForInput((Double)object);
        } else if (object instanceof Float) {
            object2 = this.transFloatForInput(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            object2 = this.transIntForInput((Integer)object);
        } else if (object instanceof Long) {
            object2 = this.transLongForInput((Long)object);
        } else if (object instanceof Short) {
            object2 = this.transShortForInput((Short)object);
        }
        return object2;
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        if (this.isNull(sQLParamController, structuredMem)) {
            return null;
        }
        return super.getString(sQLParamController, structuredMem);
    }

    public Object transStringForInput(String string) throws SQLException {
        BigDecimal bigDecimal;
        if (string == null) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newParseException(string, null);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw this.newParseException(string, null);
        }
        return this.transBigDecimalForInput(bigDecimal);
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        doubleInputFormat = DriverSapDB.currentVMVersion <= 1002999 ? new DecimalFormat("###############################################################.000000000000000000000000000000000000000000000000000000000000000", decimalFormatSymbols) : new DecimalFormat("0.0000000000000000000000000000000000000E00", decimalFormatSymbols);
        doubleInputFormat.setGroupingSize(Integer.MAX_VALUE);
    }
}

