/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

class DateTranslator
extends CharDataTranslator {
    public static final String zeroPadC = "0000";

    protected DateTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Date date = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            String string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
            try {
                date = Date.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.newParseException(string, "Date");
            }
        }
        return date;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getDate(sQLParamController, structuredMem);
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Date date = this.getDate(sQLParamController, structuredMem);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transDateForInput(Date date) throws SQLException {
        if (date == null) {
            return null;
        }
        String string = date.toString();
        int n = this.logicalLength - string.length();
        if (n > 0) {
            string = zeroPadC.substring(0, n) + string;
        }
        return string;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Date) {
            object2 = this.transDateForInput((Date)object);
        }
        return object2;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transDateForInput(Date.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                return this.transDateForInput(new Date(timestamp.getTime()));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Date");
            }
        }
    }
}

