/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.SQLPacket;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.io.PrintStream;

public class RequestPacket
extends SQLPacket {
    private static String ApplID = "ODB";
    private boolean isAvailable = false;
    private int packetLength;
    private int packetSegments;
    private int segmLength;
    private int maxNumberOfSegm = 6;
    private int segmParts;
    protected int partLength;
    private int partArguments;
    private int replyReserve;
    private int currentSqlMode = 1;
    public static final boolean reset_C = true;
    public static final boolean append_C = false;
    public static final int resultCountSize_C = 6;
    public static final int defaultmaxNumberOfSegm_C = 6;
    public static final int reserveFor2ndSegment_C = 8192;
    public static final int reserveForReply_C = 224;

    public RequestPacket(StructuredMem structuredMem) {
        this(structuredMem, 0, null);
    }

    public RequestPacket(StructuredMem structuredMem, int n, String string) {
        super(structuredMem);
        this.initPacket(n, string);
    }

    public void addBytes(byte[] byArray) {
        this.mem.putBytes(byArray, this.dataPos());
        this.partLength += byArray.length;
    }

    public void addCursorPart(String string) {
        if (string != null && string.length() != 0) {
            this.newPart(13);
            this.addString(string);
            ++this.partArguments;
            this.closePart();
        }
    }

    public void addParseidPart(byte[] byArray) {
        if (byArray != null) {
            this.newPart(10);
            this.addBytes(byArray);
            this.partArguments = 1;
            this.closePart();
        }
    }

    public void addDataBytes(byte[] byArray) {
        this.mem.putInt1(0, this.dataPos());
        this.mem.putBytes(byArray, this.dataPos() + 1);
        this.partLength += byArray.length + 1;
    }

    public void addNullData(int n) {
        this.mem.putInt1(-1, this.dataPos());
        this.partLength += n + 1;
    }

    public void addDataString(String string) {
        this.mem.putInt1(32, this.dataPos());
        this.partLength += this.mem.putString(string, this.dataPos() + 1) + 1;
    }

    public void addFetchCount(int n) {
        this.newPart(12);
        this.addBytes(VDNNumber.long2number(n));
        ++this.partArguments;
        this.setMassCommand();
    }

    public void addResultCount(int n) {
        this.newPart(12);
        byte[] byArray = VDNNumber.long2number(n);
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, 0, byArray2, 0, 6);
        this.addDataBytes(byArray2);
        ++this.partArguments;
    }

    public void addUndefResultCount() {
        this.newPart(12);
        this.addNullData(6);
        ++this.partArguments;
    }

    public void addResultsetName(String string) {
        this.newPart(13);
        this.addString(string);
    }

    public void addString(String string) {
        this.partLength += this.mem.putString(string, this.dataPos());
    }

    public void closePacket() {
        this.closeSegment();
        this.mem.putInt4(this.packetLength, 16);
        this.mem.putInt2(this.packetSegments, 22);
    }

    private void closePart() {
        this.closePart(this.partLength, this.partArguments);
    }

    void closePart(int n, int n2) {
        if (this.partOffs == -1) {
            return;
        }
        this.mem.putInt4(n, this.partOffs + 8);
        this.mem.putInt2(n2, this.partOffs + 2);
        this.segmLength += this.aligned(n + 16);
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
    }

    private void closeSegment() {
        if (this.segmOffs == -1) {
            return;
        }
        this.closePart();
        this.mem.putInt4(this.segmLength, this.segmOffs + 0);
        this.mem.putInt2(this.segmParts, this.segmOffs + 8);
        this.packetLength += this.segmLength;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
    }

    protected int dataPos() {
        return this.partOffs + 16 + this.partLength;
    }

    public boolean dropPid(byte[] byArray, boolean bl) {
        if (bl) {
            this.resetPacket();
        } else {
            int n;
            if (this.segmOffs != -1) {
                this.closeSegment();
            }
            if ((n = this.size() - this.packetLength - 40 - 16 - this.replyReserve - 224 - 12 - 40 - 16 - 12) <= 0 || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.newSegment(2, false);
        this.newPart(3);
        this.partArguments = 1;
        this.addString("Drop Parseid");
        this.newPart(10);
        this.partArguments = 1;
        this.addBytes(byArray);
        return true;
    }

    int dumpSegment(PrintStream printStream, int n, int n2) {
        printStream.println("   <SEGMENT ");
        printStream.println("    type=\"REQUEST\"");
        printStream.println("    index=\"" + this.getInt2(n2 + 10) + "\"");
        printStream.println("    offset=\"" + this.getInt4(n2 + 4) + "\"");
        printStream.println("    length=\"" + this.getInt4(n2 + 0) + "\"");
        printStream.println("    number_of_parts=\"" + this.getInt2(n2 + 8) + "\"");
        StringUtil.fprintfs(printStream, "    <! Detailed info skipped >\n", new Object[0]);
        int n3 = this.getInt2(n2 + 8);
        int n4 = n2 + 40;
        int n5 = 0;
        while (n5 < n3) {
            n4 += this.dumpPart(printStream, n, n4);
            ++n5;
        }
        printStream.println("   </SEGMENT> ");
        return this.getInt4(n2 + 0);
    }

    private void flushVariables() {
        this.mem.putInt4(this.packetLength, 16);
        this.mem.putInt2(this.packetSegments, 22);
        if (this.segmOffs != -1) {
            this.mem.putInt4(this.segmLength, this.segmOffs + 0);
            this.mem.putInt2(this.segmParts, this.segmOffs + 8);
        }
        if (this.partOffs != -1) {
            this.mem.putInt4(this.partLength, this.partOffs + 8);
            this.mem.putInt2(this.partArguments, this.partOffs + 2);
        }
    }

    public void incrPartArguments() {
        ++this.partArguments;
    }

    public void initHello() {
        this.resetPacket();
        this.newSegment(25, false);
    }

    public void initDbs(boolean bl) {
        this.initDbs(true, bl);
    }

    public void initDbs(boolean bl, boolean bl2) {
        if (bl) {
            this.resetPacket();
        }
        this.newSegment(2, bl2);
        this.newPart(3);
        this.partArguments = 1;
    }

    public void initDbsCommand(boolean bl, String string) {
        this.initDbsCommand(string, true, bl);
    }

    public boolean initDbsCommand(String string, boolean bl, boolean bl2) {
        if (!bl) {
            this.closeSegment();
            int n = this.size() - this.packetLength - 40 - 16 - this.replyReserve - 224;
            if (n < string.length() || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.initDbs(bl, bl2);
        this.addString(string);
        this.partArguments = 1;
        return true;
    }

    public boolean initSyntaxOnlyCommand(String string) {
        this.resetPacket();
        this.newSegment(5, false);
        this.newPart(3);
        this.partArguments = 1;
        this.addString(string);
        return true;
    }

    public void initExecute(byte[] byArray, boolean bl) {
        this.resetPacket();
        this.newSegment(13, bl);
        this.addParseidPart(byArray);
    }

    public DataPart initGetval(boolean bl) {
        this.resetPacket();
        this.newSegment(16, bl);
        return this.newDataPart(18);
    }

    public void initMFetch(byte[] byArray, int n, boolean bl) {
        this.resetPacket();
        this.newSegment(13, bl);
        this.newPart(10);
        this.addBytes(byArray);
        this.partArguments = 1;
        this.addResultCount(n);
        this.setMassCommand();
    }

    private void initPacket(int n, String string) {
        StructuredMem structuredMem = this.mem;
        if (string != null) {
            ApplID = string;
        }
        structuredMem.putInt1(n, 0);
        structuredMem.putInt1(1, 1);
        structuredMem.putString("70400", 4);
        structuredMem.putString(ApplID, 9);
        structuredMem.putInt4(structuredMem.size(), 12);
    }

    public void initParse() {
        this.initParse(true);
    }

    public void initParse(boolean bl) {
        if (bl) {
            this.resetPacket();
        }
        this.newSegment(3, false);
        this.newPart(3);
    }

    public int initParseCommand(String string) {
        return this.initParseCommand(string, true);
    }

    public int initParseCommand(String string, boolean bl) {
        this.initParse(bl);
        this.addString(string);
        this.partArguments = 1;
        return this.partLength;
    }

    private void initPart(int n) {
        StructuredMem structuredMem = this.mem;
        ++this.segmParts;
        this.partOffs = this.segmOffs + this.segmLength;
        this.partLength = 0;
        this.partArguments = 0;
        int n2 = this.partOffs;
        structuredMem.putInt1(n, n2 + 0);
        structuredMem.putInt1(0, n2 + 1);
        structuredMem.putInt2(1, n2 + 2);
        structuredMem.putInt4(this.segmOffs - 32, n2 + 4);
        structuredMem.putInt4(16, n2 + 8);
        structuredMem.putInt4(structuredMem.size() - n2, n2 + 12);
    }

    public DataPart initPutval(boolean bl) {
        this.resetPacket();
        this.newSegment(15, bl);
        return this.newDataPart(18);
    }

    private void initSegment(int n, boolean bl) {
        int n2;
        StructuredMem structuredMem = this.mem;
        this.segmOffs = n2 = this.packetLength;
        this.segmLength = 40;
        this.segmParts = 0;
        ++this.packetSegments;
        structuredMem.putInt4(0, n2 + 0);
        structuredMem.putInt4(n2 - 32, n2 + 4);
        structuredMem.putInt2(0, n2 + 8);
        structuredMem.putInt2(this.packetSegments, n2 + 10);
        structuredMem.putInt1(1, n2 + 12);
        structuredMem.putInt1(n, n2 + 13);
        structuredMem.putInt1(this.currentSqlMode, n2 + 14);
        structuredMem.putInt1(1, n2 + 15);
        structuredMem.putInt1(0, n2 + 16);
        structuredMem.putInt1(0, n2 + 17);
        structuredMem.putInt1(0, n2 + 18);
        structuredMem.putInt1(0, n2 + 19);
        structuredMem.putInt1(0, n2 + 20);
        structuredMem.putInt1(0, n2 + 21);
        structuredMem.putInt1(bl ? 1 : 0, n2 + 16);
    }

    public int length() {
        return this.packetLength;
    }

    public DataPart newDataPart() {
        return this.newDataPart(5);
    }

    public DataPart newDataPart(int n) {
        this.newPart(n);
        int n2 = this.partOffs + 16;
        DataPart dataPart = new DataPart(this.getPointer(n2), this);
        return dataPart;
    }

    public void newPart(int n) {
        this.closePart();
        this.initPart(n);
    }

    private void newSegment(int n, boolean bl) {
        this.closeSegment();
        this.initSegment(n, bl);
        this.replyReserve = this.packetSegments == 2 ? (this.replyReserve += 8192) : (this.replyReserve += 224);
    }

    public void initializePacket(short s) {
        this.resetPacket();
        this.maxNumberOfSegm = s;
    }

    private void resetPacket() {
        this.packetLength = 32;
        this.packetSegments = 0;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
        this.maxNumberOfSegm = 6;
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
        this.replyReserve = 0;
    }

    public static int resultCountPartSize() {
        return 30;
    }

    public void setMaxSegment(short s) {
        this.maxNumberOfSegm = s;
    }

    public void setAdabasMode() {
        this.putInt1(2, this.segmOffs + 14);
    }

    public void setAvailability(boolean bl) {
        this.isAvailable = bl;
    }

    public void setInternalCmd() {
        this.mem.putInt1(2, this.segmOffs + 15);
    }

    public void setMassCommand() {
        this.putInt1(1, this.segmOffs + 20);
    }

    public void setWithInfo() {
        this.putInt1(1, this.segmOffs + 19);
    }

    public int switchSqlMode(int n) {
        int n2 = this.currentSqlMode;
        this.currentSqlMode = n;
        return n2;
    }

    void addPartAttribute(int n) {
        int n2 = this.partOffs + 1;
        int n3 = this.getInt1(n2);
        this.putInt1(n3 |= n, n2);
    }
}

