/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.util;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class StringUtils {
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "org.apache.tools.ant."};
    private static final String[] DEFAULT_STOP_FILTERS = new String[]{"junit.framework.TestCase.runTest"};

    public static String htmlText(String text) {
        StringBuffer sb = new StringBuffer();
        if (text == null) {
            return "";
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\n': {
                    sb.append("<br>");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String xmlText(String text) {
        StringBuffer sb = new StringBuffer();
        if (text == null) {
            return "";
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String filterStack(String stack) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                void var5_5;
                if (StringUtils.stopLine((String)var5_5)) {
                    pw.println((String)var5_5);
                    break;
                }
                if (StringUtils.filterLine((String)var5_5)) continue;
                pw.println((String)var5_5);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        int i = 0;
        while (i < DEFAULT_TRACE_FILTERS.length) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean stopLine(String line) {
        int i = 0;
        while (i < DEFAULT_STOP_FILTERS.length) {
            if (line.indexOf(DEFAULT_STOP_FILTERS[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

