/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.runner;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import org.junitee.runner.TestRunnerListener;
import org.junitee.runner.TestSuiteLoader;

public class TestRunner
extends BaseTestRunner {
    private junit.runner.TestSuiteLoader loader;
    private TestRunnerListener listener;
    private volatile boolean run = false;
    private boolean forkThread;
    static /* synthetic */ Class class$java$lang$String;

    public TestRunner(ClassLoader loader, TestRunnerListener listener, boolean forkThread) {
        this.listener = listener;
        this.loader = new TestSuiteLoader(loader);
        this.forkThread = forkThread;
    }

    public void stop() {
        this.run = false;
        this.listener.setStopped();
    }

    public void run(final String[] testClassNames) {
        Runnable runnable = new Runnable(){

            public void run() {
                TestResult result = new TestResult();
                result.addListener((TestListener)TestRunner.this.listener);
                TestRunner.this.listener.start(false);
                int i = 0;
                while (i < testClassNames.length) {
                    Test test = TestRunner.this.getTest(testClassNames[i]);
                    if (test != null) {
                        test.run(result);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!TestRunner.this.run && i != testClassNames.length - 1) {
                        TestRunner.this.runFailed("Execution was stopped");
                        break;
                    }
                    ++i;
                }
                TestRunner.this.listener.finish();
            }
        };
        this.run = true;
        if (testClassNames.length > 1 && this.forkThread) {
            Thread thread = new Thread(runnable, ((Object)((Object)this)).toString());
            thread.start();
        } else {
            runnable.run();
        }
    }

    public void run(String testClassName, String testName) {
        TestResult result = new TestResult();
        result.addListener((TestListener)this.listener);
        this.listener.start(true);
        Test test = this.getTest(testClassName, testName);
        if (test != null) {
            test.run(result);
        }
        this.listener.finish();
    }

    public junit.runner.TestSuiteLoader getLoader() {
        return this.loader;
    }

    protected void runFailed(String className) {
        this.listener.runFailed(className);
    }

    protected Test getTest(String suiteClassName, String testName) {
        try {
            Class clazz = this.loadSuiteClass(suiteClassName);
            Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = TestRunner.class$("java.lang.String")) : class$java$lang$String);
            Method tmp = clazz.getMethod(testName, new Class[0]);
            return (Test)constructor.newInstance(testName);
        }
        catch (ClassNotFoundException e) {
            this.runFailed("Class not found \"" + suiteClassName + "\"");
        }
        catch (InstantiationException e) {
            this.runFailed("Could not create instance of class \"" + suiteClassName + "\" (" + e.getMessage() + ")");
        }
        catch (IllegalAccessException e) {
            this.runFailed("Could not create instance of class \"" + suiteClassName + "\" (" + e.getMessage() + ")");
        }
        catch (InvocationTargetException e) {
            this.runFailed("Could not create instance of class \"" + suiteClassName + "\" (" + e.getMessage() + ")");
        }
        catch (NoSuchMethodException e) {
            this.runFailed("No method \"" + testName + "\" in class \"" + suiteClassName + "\"");
        }
        return null;
    }

    public void addError(Test test, Throwable throwable) {
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

