/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.web.WebClassLoader;

public class WebServer
implements Runnable {
    private static Logger log = Logger.getLogger(WebServer.class);
    private int port = 8083;
    private InetAddress bindAddress;
    private int backlog = 50;
    private final ConcurrentReaderHashMap loaderMap = new ConcurrentReaderHashMap();
    private ServerSocket server = null;
    private boolean downloadServerClasses = true;
    private boolean downloadResources = false;
    private static final Properties mimeTypes = new Properties();
    private BasicThreadPoolMBean threadPool;

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public String getBindHostname() {
        return this.bindAddress.getHostName();
    }

    public void setBindAddress(String host) {
        try {
            if (host != null) {
                String h = StringPropertyReplacer.replaceProperties(host);
                this.bindAddress = InetAddress.getByName(h);
            }
        }
        catch (UnknownHostException e) {
            String msg = "Invalid host address specified: " + host;
            log.error(msg, e);
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public boolean getDownloadServerClasses() {
        return this.downloadServerClasses;
    }

    public void setDownloadServerClasses(boolean flag) {
        this.downloadServerClasses = flag;
    }

    public boolean getDownloadResources() {
        return this.downloadResources;
    }

    public void setDownloadResources(boolean flag) {
        this.downloadResources = flag;
    }

    public BasicThreadPoolMBean getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(BasicThreadPoolMBean threadPool) {
        this.threadPool = threadPool;
    }

    public void addMimeType(String extension, String type) {
        mimeTypes.put(extension, type);
    }

    public void start() throws Exception {
        if (this.threadPool == null) {
            this.threadPool = new BasicThreadPool("ClassLoadingPool");
        }
        try {
            this.server = new ServerSocket(this.port, this.backlog, this.bindAddress);
            log.debug("Started server: " + this.server);
            this.listen();
        }
        catch (BindException be) {
            throw new Exception("Port " + this.port + " already in use.", be);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void stop() {
        try {
            ServerSocket srv = this.server;
            this.server = null;
            srv.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL addClassLoader(ClassLoader cl) {
        String key = cl instanceof WebClassLoader ? ((WebClassLoader)cl).getKey() : this.getClassLoaderKey(cl);
        this.loaderMap.put((Object)key, (Object)cl);
        URL loaderURL = null;
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase != null) {
            if (!codebase.endsWith("/")) {
                codebase = codebase + '/';
            }
            codebase = codebase + key;
            codebase = codebase + '/';
            try {
                loaderURL = new URL(codebase);
            }
            catch (MalformedURLException e) {
                log.error("invalid url", e);
            }
        }
        log.trace("Added ClassLoader: " + cl + " URL: " + loaderURL);
        return loaderURL;
    }

    public void removeClassLoader(ClassLoader cl) {
        String key = this.getClassLoaderKey(cl);
        this.loaderMap.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.server == null) {
            return;
        }
        Socket socket = null;
        try {
            socket = this.server.accept();
        }
        catch (IOException e) {
            if (this.server != null) {
                log.error("Failed to accept connection", e);
            }
            return;
        }
        this.listen();
        try {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            try {
                String httpCode = "200 OK";
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String rawPath = this.getPath(in);
                int endOfKey = rawPath.indexOf(93);
                String filePath = rawPath.substring(endOfKey + 2);
                String loaderKey = rawPath.substring(0, endOfKey + 1);
                log.trace("loaderKey = " + loaderKey);
                log.trace("filePath = " + filePath);
                ClassLoader loader = (ClassLoader)this.loaderMap.get((Object)loaderKey);
                if (loader == null && rawPath.indexOf(91) < 0 && this.downloadServerClasses) {
                    filePath = rawPath;
                    log.trace("No loader, reset filePath = " + filePath);
                    loader = Thread.currentThread().getContextClassLoader();
                }
                log.trace("loader = " + loader);
                byte[] bytes = new byte[]{};
                if (loader != null && filePath.endsWith(".class")) {
                    String className = filePath.substring(0, filePath.length() - 6).replace('/', '.');
                    log.trace("loading className = " + className);
                    Class<?> clazz = loader.loadClass(className);
                    URL clazzUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
                    log.trace("clazzUrl = " + clazzUrl);
                    if (clazzUrl == null) {
                        bytes = ((WebClassLoader)clazz.getClassLoader()).getBytes(clazz);
                        if (bytes == null) {
                            throw new Exception("Class not found: " + className);
                        }
                    } else {
                        if (!clazzUrl.getFile().endsWith("/")) {
                            clazzUrl = new URL("jar:" + clazzUrl + "!/" + filePath);
                        } else if (clazzUrl.getFile().indexOf("/org_jboss_aop_proxy$") < 0) {
                            clazzUrl = new URL(clazzUrl, filePath);
                        }
                        log.trace("new clazzUrl: " + clazzUrl);
                        bytes = this.getBytes(clazzUrl);
                    }
                } else if (loader != null && filePath.length() > 0 && this.downloadServerClasses && this.downloadResources) {
                    log.trace("loading resource = " + filePath);
                    URL resourceURL = loader.getResource(filePath);
                    if (resourceURL == null) {
                        httpCode = "404 Resource not found:" + filePath;
                    } else {
                        log.trace("resourceURL = " + resourceURL);
                        bytes = this.getBytes(resourceURL);
                    }
                } else {
                    httpCode = "404 Not Found";
                }
                try {
                    log.trace("HTTP code=" + httpCode + ", Content-Length: " + bytes.length);
                    out.writeBytes("HTTP/1.0 " + httpCode + "\r\n");
                    out.writeBytes("Content-Length: " + bytes.length + "\r\n");
                    out.writeBytes("Content-Type: " + this.getMimeType(filePath));
                    out.writeBytes("\r\n\r\n");
                    out.write(bytes);
                    out.flush();
                }
                catch (IOException ie) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable e) {
                try {
                    log.trace("HTTP code=404 " + e.getMessage());
                    out.writeBytes("HTTP/1.0 400 " + e.getMessage() + "\r\n");
                    out.writeBytes("Content-Type: text/html\r\n\r\n");
                    out.flush();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            log.error("error writting response", ex);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getClassLoaderKey(ClassLoader cl) {
        String className = cl.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String key = className + '[' + cl.hashCode() + ']';
        return key;
    }

    protected void listen() {
        this.threadPool.getInstance().run(this);
    }

    protected String getPath(BufferedReader in) throws IOException {
        String line = in.readLine();
        log.trace("raw request=" + line);
        int start = line.indexOf(32) + 1;
        int end = line.indexOf(32, start + 1);
        String filePath = line.substring(start + 1, end);
        return filePath;
    }

    protected byte[] getBytes(URL url) throws IOException {
        int bytes;
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        log.debug("Retrieving " + url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        while ((bytes = ((InputStream)in).read(tmp)) != -1) {
            out.write(tmp, 0, bytes);
        }
        ((InputStream)in).close();
        return out.toByteArray();
    }

    protected String getMimeType(String path) {
        String suffix;
        String mimeType;
        int dot = path.lastIndexOf(".");
        String type = "text/html";
        if (dot >= 0 && (mimeType = mimeTypes.getProperty(suffix = path.substring(dot + 1))) != null) {
            type = mimeType;
        }
        return type;
    }
}

