/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.inflow.GetTCLAction;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb.plugins.inflow.SetTCLAction;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.Interceptor;

public class MessageEndpointInterceptor
extends Interceptor {
    private static final Logger log = Logger.getLogger(MessageEndpointInterceptor.class);
    public static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpoint.Factory";
    public static final String MESSAGE_ENDPOINT_XARESOURCE = "MessageEndpoint.XAResource";
    private boolean trace = log.isTraceEnabled();
    private String cachedProxyString = null;
    protected SynchronizedBoolean released = new SynchronizedBoolean(false);
    protected boolean delivered = false;
    protected Thread inUseThread = null;
    protected ClassLoader oldClassLoader = null;
    protected Transaction transaction = null;
    protected Transaction suspended = null;
    private JBossMessageEndpointFactory endpointFactory;

    public Object invoke(Invocation mi) throws Throwable {
        if (this.released.get()) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " has been released");
        }
        Thread currentThread = Thread.currentThread();
        if (this.inUseThread != null && !this.inUseThread.equals(currentThread)) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " is already in use by another thread " + this.inUseThread);
        }
        this.inUseThread = currentThread;
        String method = mi.getMethod().getName();
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " in use by " + method + " " + this.inUseThread);
        }
        if (method.equals("release")) {
            this.release(mi);
            return null;
        }
        if (method.equals("beforeDelivery")) {
            this.before(mi);
            return null;
        }
        if (method.equals("afterDelivery")) {
            this.after(mi);
            return null;
        }
        return this.delivery(mi);
    }

    protected void release(Invocation mi) throws Throwable {
        this.released.set(true);
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " released");
        }
        if (this.oldClassLoader != null) {
            try {
                this.finish("release", mi, false);
            }
            catch (Throwable t) {
                log.warn("Error in release ", t);
            }
        }
    }

    protected void before(Invocation mi) throws Throwable {
        if (this.oldClassLoader != null) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " released");
        }
        MessageDrivenContainer container = this.getContainer(mi);
        this.oldClassLoader = GetTCLAction.getContextClassLoader(this.inUseThread);
        SetTCLAction.setContextClassLoader(this.inUseThread, container.getClassLoader());
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " set context classloader to " + container.getClassLoader());
        }
        try {
            this.startTransaction("beforeDelivery", mi, container);
        }
        catch (Throwable t) {
            this.resetContextClassLoader(mi);
            throw new ResourceException(t);
        }
    }

    protected void after(Invocation mi) throws Throwable {
        if (this.oldClassLoader == null) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        try {
            this.finish("afterDelivery", mi, true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delivery(Invocation mi) throws Throwable {
        if (this.delivered) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + this.getProxyString(mi));
        }
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " delivering");
        }
        if (this.oldClassLoader != null) {
            this.delivered = true;
        }
        MessageDrivenContainer container = this.getContainer(mi);
        boolean commit = true;
        try {
            if (this.oldClassLoader == null) {
                this.startTransaction("delivery", mi, container);
            }
            Object object = this.getNext().invoke(mi);
            return object;
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace("MessageEndpoint " + this.getProxyString(mi) + " delivery error", t);
            }
            if (t instanceof Error || t instanceof RuntimeException) {
                if (this.transaction != null) {
                    this.transaction.setRollbackOnly();
                }
                commit = false;
            }
            throw t;
        }
        finally {
            if (this.oldClassLoader == null) {
                try {
                    this.endTransaction(mi, commit);
                }
                finally {
                    this.releaseThreadLock(mi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String context, Invocation mi, boolean commit) throws Throwable {
        try {
            this.endTransaction(mi, commit);
        }
        finally {
            this.delivered = false;
            this.resetContextClassLoader(mi);
            this.releaseThreadLock(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransaction(String context, Invocation mi, MessageDrivenContainer container) throws Throwable {
        XAResource resource = (XAResource)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_XARESOURCE);
        Method method = null;
        method = "delivery".equals(context) ? mi.getMethod() : (Method)mi.getArguments()[0];
        boolean isTransacted = this.getMessageEndpointFactory(mi).isDeliveryTransacted(method);
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " " + context + " method=" + method + " xaResource=" + resource + " transacted=" + isTransacted);
        }
        TransactionManager tm = container.getTransactionManager();
        this.suspended = tm.suspend();
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " " + context + " currentTx=" + this.suspended);
        }
        if (isTransacted) {
            if (this.suspended == null) {
                tm.begin();
                this.transaction = tm.getTransaction();
                if (this.trace) {
                    log.trace("MessageEndpoint " + this.getProxyString(mi) + " started transaction=" + this.transaction);
                }
                if (resource != null) {
                    this.transaction.enlistResource(resource);
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(mi) + " enlisted=" + resource);
                    }
                }
            } else {
                try {
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(mi) + " transaction=" + this.suspended + " already active, IGNORED=" + resource);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void endTransaction(Invocation mi, boolean commit) throws Throwable {
        TransactionManager tm = null;
        Transaction currentTx = null;
        try {
            if (this.transaction != null) {
                tm = this.getContainer(mi).getTransactionManager();
                currentTx = tm.getTransaction();
                if (currentTx != null && !currentTx.equals(this.transaction)) {
                    log.warn("Current transaction " + currentTx + " is not the expected transaction.");
                    tm.suspend();
                    tm.resume(this.transaction);
                } else {
                    currentTx = null;
                }
                if (!commit || this.transaction.getStatus() == 1) {
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(mi) + " rollback");
                    }
                    tm.rollback();
                } else {
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(mi) + " commit");
                    }
                    tm.commit();
                }
            }
            if (this.suspended != null) {
                try {
                    tm = this.getContainer(mi).getTransactionManager();
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                }
            }
            if (currentTx == null) return;
        }
        catch (Throwable throwable) {
            if (currentTx == null) throw throwable;
            try {
                tm.resume(currentTx);
                throw throwable;
            }
            catch (Throwable t) {
                log.warn("MessageEndpoint " + this.getProxyString(mi) + " failed to resume old transaction " + currentTx);
            }
            throw throwable;
        }
        try {
            tm.resume(currentTx);
            return;
        }
        catch (Throwable t) {
            log.warn("MessageEndpoint " + this.getProxyString(mi) + " failed to resume old transaction " + currentTx);
        }
    }

    protected void resetContextClassLoader(Invocation mi) {
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " reset classloader " + this.oldClassLoader);
        }
        SetTCLAction.setContextClassLoader(this.inUseThread, this.oldClassLoader);
        this.oldClassLoader = null;
    }

    protected void releaseThreadLock(Invocation mi) {
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(mi) + " no longer in use by " + this.inUseThread);
        }
        this.inUseThread = null;
    }

    protected String getProxyString(Invocation mi) {
        if (this.cachedProxyString == null) {
            this.cachedProxyString = mi.getInvocationContext().getCacheId().toString();
        }
        return this.cachedProxyString;
    }

    protected JBossMessageEndpointFactory getMessageEndpointFactory(Invocation mi) {
        if (this.endpointFactory == null) {
            this.endpointFactory = (JBossMessageEndpointFactory)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_FACTORY);
        }
        return this.endpointFactory;
    }

    protected MessageDrivenContainer getContainer(Invocation mi) {
        return this.getMessageEndpointFactory(mi).getContainer();
    }
}

