/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.util.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javancss.Formatter;
import javancss.Javancss;
import javancss.JavancssConstants;
import javancss.PackageMetric;

public class XmlFormatter
implements Formatter,
JavancssConstants {
    private Javancss _javancss = null;
    static NumberFormat _pNumberFormat = null;

    private double _divide(int divident, int divisor) {
        double dRetVal = 0.0;
        if (divisor > 0) {
            dRetVal = (double)Math.round((double)divident / (double)divisor * 100.0) / 100.0;
        }
        return dRetVal;
    }

    private double _divide(long divident, long divisor) {
        double dRetVal = 0.0;
        if (divisor > 0L) {
            dRetVal = (double)Math.round((double)divident / (double)divisor * 100.0) / 100.0;
        }
        return dRetVal;
    }

    private String _formatPackageMatrix(int packages, int classesSum, int functionsSum, int ncssSum, int javadocsSum, int javadocLnSum, int singleLnSum, int multiLnSum) {
        String sRetVal = "    <table>\n      <tr><td>Packages</td><td>Classes</td><td>Functions</td><td>NCSS</td><td>Javadocs</td><td>per</td></tr>\n      <tr><td>" + _pNumberFormat.format(packages) + "</td><td>" + _pNumberFormat.format(classesSum) + "</td><td>" + _pNumberFormat.format(functionsSum) + "</td><td>" + _pNumberFormat.format(ncssSum) + "</td><td>" + _pNumberFormat.format(javadocsSum) + "</td><td>Project</td></tr>\n" + "      <tr><td></td><td>" + _pNumberFormat.format(this._divide(classesSum, packages)) + "</td><td>" + _pNumberFormat.format(this._divide(functionsSum, packages)) + "</td><td>" + _pNumberFormat.format(this._divide(ncssSum, packages)) + "</td><td>" + _pNumberFormat.format(this._divide(javadocsSum, packages)) + "</td><td>Package</td></tr>\n" + "      <tr><td></td><td></td><td>" + _pNumberFormat.format(this._divide(functionsSum, classesSum)) + "</td><td>" + _pNumberFormat.format(this._divide(ncssSum, classesSum)) + "</td><td>" + _pNumberFormat.format(this._divide(javadocsSum, classesSum)) + "</td><td>Class</td></tr>\n" + "      <tr><td></td><td></td><td></td><td>" + _pNumberFormat.format(this._divide(ncssSum, functionsSum)) + "</td><td>" + _pNumberFormat.format(this._divide(javadocsSum, functionsSum)) + "</td><td>Function</td></tr>\n" + "    </table>\n";
        return sRetVal;
    }

    public XmlFormatter(Javancss javancss) {
        this._javancss = javancss;
        _pNumberFormat = NumberFormat.getInstance(Locale.US);
        ((DecimalFormat)_pNumberFormat).applyPattern("#,##0.00");
    }

    public String printPackageNcss() {
        String sRetVal = "  <packages>\n";
        Vector vPackageMetrics = this._javancss.getPackageMetrics();
        int packages = vPackageMetrics.size();
        int classesSum = 0;
        int functionsSum = 0;
        int ncssSum = 0;
        int javadocSum = 0;
        int javadocLnSum = 0;
        int singleLnSum = 0;
        int multiLnSum = 0;
        Enumeration ePackages = vPackageMetrics.elements();
        while (ePackages.hasMoreElements()) {
            PackageMetric pPackageMetric = (PackageMetric)ePackages.nextElement();
            classesSum += pPackageMetric.classes;
            functionsSum += pPackageMetric.functions;
            ncssSum += pPackageMetric.ncss;
            javadocSum += pPackageMetric.javadocs;
            javadocLnSum += pPackageMetric.javadocsLn;
            singleLnSum += pPackageMetric.singleLn;
            multiLnSum += pPackageMetric.multiLn;
            sRetVal = sRetVal + "    <package>\n      <name>" + pPackageMetric.name + "</name>\n" + "      <classes>" + pPackageMetric.classes + "</classes>\n" + "      <functions>" + pPackageMetric.functions + "</functions>\n" + "      <ncss>" + pPackageMetric.ncss + "</ncss>\n" + "      <javadocs>" + pPackageMetric.javadocs + "</javadocs>\n" + "      <javadoc_lines>" + pPackageMetric.javadocsLn + "</javadoc_lines>\n" + "      <single_comment_lines>" + pPackageMetric.singleLn + "</single_comment_lines>\n" + "      <multi_comment_lines>" + pPackageMetric.multiLn + "</multi_comment_lines>\n" + "    </package>\n";
        }
        sRetVal = sRetVal + "    <total>\n      <classes>" + classesSum + "</classes>\n" + "      <functions>" + functionsSum + "</functions>\n" + "      <ncss>" + ncssSum + "</ncss>\n" + "      <javadocs>" + javadocSum + "</javadocs>\n" + "      <javadoc_lines>" + javadocLnSum + "</javadoc_lines>\n" + "      <single_comment_lines>" + singleLnSum + "</single_comment_lines>\n" + "      <multi_comment_lines>" + multiLnSum + "</multi_comment_lines>\n" + "    </total>\n";
        sRetVal = sRetVal + this._formatPackageMatrix(packages, classesSum, functionsSum, ncssSum, javadocSum, javadocLnSum, singleLnSum, multiLnSum);
        sRetVal = sRetVal + "  </packages>\n";
        return sRetVal;
    }

    private String _formatObjectResume(int objects, long lObjectSum, long lFunctionSum, long lClassesSum, long lJVDCSum, long lJVDCLSum, long lSLSum, long lMLSum) {
        double fAverageNcss = this._divide(lObjectSum, (long)objects);
        double fAverageFuncs = this._divide(lFunctionSum, (long)objects);
        double fAverageClasses = this._divide(lClassesSum, (long)objects);
        double fAverageJavadocs = this._divide(lJVDCSum, (long)objects);
        double fAverageJVDCL = this._divide(lJVDCLSum, (long)objects);
        double fAverageSL = this._divide(lSLSum, (long)objects);
        double fAverageML = this._divide(lMLSum, (long)objects);
        String sRetVal = "    <averages>\n      <ncss>" + _pNumberFormat.format(fAverageNcss) + "</ncss>\n" + "      <functions>" + _pNumberFormat.format(fAverageFuncs) + "</functions>\n" + "      <classes>" + _pNumberFormat.format(fAverageClasses) + "</classes>\n" + "      <javadocs>" + _pNumberFormat.format(fAverageJavadocs) + "</javadocs>\n" + "    </averages>\n" + "    <ncss>" + _pNumberFormat.format(this._javancss.getNcss()) + "</ncss>\n";
        return sRetVal;
    }

    public String printObjectNcss() {
        String sRetVal = "  <objects>\n";
        Vector vObjectMetrics = this._javancss.getObjectMetrics();
        long lFunctionSum = 0L;
        long lClassesSum = 0L;
        long lObjectSum = 0L;
        long lJVDCSum = 0L;
        Enumeration eClasses = vObjectMetrics.elements();
        while (eClasses.hasMoreElements()) {
            Vector vClassMetrics = (Vector)eClasses.nextElement();
            String sClass = (String)vClassMetrics.elementAt(0);
            int objectNcss = (Integer)vClassMetrics.elementAt(1);
            int functions = (Integer)vClassMetrics.elementAt(2);
            int classes = (Integer)vClassMetrics.elementAt(3);
            int jvdcs = (Integer)vClassMetrics.elementAt(6);
            int jvdcsl = (Integer)vClassMetrics.elementAt(7);
            int singlel = (Integer)vClassMetrics.elementAt(8);
            int multil = (Integer)vClassMetrics.elementAt(9);
            lObjectSum += (long)objectNcss;
            lFunctionSum += (long)functions;
            lClassesSum += (long)classes;
            lJVDCSum += (long)jvdcs;
            sRetVal = sRetVal + "    <object>\n      <name>" + sClass + "</name>\n" + "      <ncss>" + objectNcss + "</ncss>\n" + "      <functions>" + functions + "</functions>\n" + "      <classes>" + classes + "</classes>\n" + "      <javadocs>" + jvdcs + "</javadocs>\n" + "    </object>\n";
        }
        sRetVal = sRetVal + this._formatObjectResume(vObjectMetrics.size(), lObjectSum, lFunctionSum, lClassesSum, lJVDCSum, this._javancss.getJdcl(), this._javancss.getSl(), this._javancss.getMl());
        sRetVal = sRetVal + "  </objects>\n";
        return sRetVal;
    }

    private String _formatFunctionResume(int functions, long lFunctionSum, long lCCNSum, long lJVDCSum, long lJVDCLSum, long lSLSum, long lMLSum) {
        StringBuffer sRetVal = new StringBuffer();
        double fAverageNcss = this._divide(lFunctionSum, (long)functions);
        double fAverageCCN = this._divide(lCCNSum, (long)functions);
        double fAverageJVDC = this._divide(lJVDCSum, (long)functions);
        double fAverageJVDCL = this._divide(lJVDCLSum, (long)functions);
        double fAverageSL = this._divide(lSLSum, (long)functions);
        double fAverageML = this._divide(lMLSum, (long)functions);
        sRetVal.append("    <function_averages>\n      <ncss>" + _pNumberFormat.format(fAverageNcss) + "</ncss>\n" + "      <ccn>" + _pNumberFormat.format(fAverageCCN) + "</ccn>\n" + "      <javadocs>" + _pNumberFormat.format(fAverageJVDC) + "</javadocs>\n" + "    </function_averages>\n" + "    <ncss>" + _pNumberFormat.format(this._javancss.getNcss()) + "</ncss>\n");
        return sRetVal.toString();
    }

    public String printFunctionNcss() {
        StringBuffer sRetVal = new StringBuffer(80000);
        sRetVal.append("  <functions>\n");
        Vector vFunctionMetrics = this._javancss.getFunctionMetrics();
        long lFunctionSum = 0L;
        long lCCNSum = 0L;
        long lJVDCSum = 0L;
        Enumeration eFunctions = vFunctionMetrics.elements();
        while (eFunctions.hasMoreElements()) {
            Vector vSingleFunctionMetrics = (Vector)eFunctions.nextElement();
            String sFunction = null;
            sFunction = (String)vSingleFunctionMetrics.elementAt(0);
            int functionNcss = (Integer)vSingleFunctionMetrics.elementAt(1);
            int functionCCN = (Integer)vSingleFunctionMetrics.elementAt(2);
            int functionJVDC = (Integer)vSingleFunctionMetrics.elementAt(3);
            int functionJVDCL = (Integer)vSingleFunctionMetrics.elementAt(4);
            int functionSL = (Integer)vSingleFunctionMetrics.elementAt(5);
            int functionML = (Integer)vSingleFunctionMetrics.elementAt(6);
            lFunctionSum += (long)functionNcss;
            lCCNSum += (long)functionCCN;
            lJVDCSum += (long)functionJVDC;
            sRetVal.append("    <function>\n      <name>" + sFunction + "</name>\n" + "      <ncss>" + functionNcss + "</ncss>\n" + "      <ccn>" + functionCCN + "</ccn>\n" + "      <javadocs>" + functionJVDC + "</javadocs>\n" + "    </function>\n");
        }
        sRetVal.append(this._formatFunctionResume(vFunctionMetrics.size(), lFunctionSum, lCCNSum, lJVDCSum, this._javancss.getJdcl(), this._javancss.getSl(), this._javancss.getMl()));
        sRetVal.append("  </functions>\n");
        return sRetVal.toString();
    }

    public String printJavaNcss() {
        return "  <ncss>" + this._javancss.getNcss() + "</ncss>\n";
    }

    public static String printStart() {
        Calendar calendar = Util.getCalendar();
        return "<?xml version=\"1.0\"?>\n<javancss>\n  <date>" + Util.getDate(calendar) + "</date>\n" + "  <time>" + Util.getTime(calendar) + "</time>\n";
    }

    public static String printEnd() {
        return "</javancss>\n";
    }
}

