/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.messaging.util.Streamable;

public class CreateConnectionResult
implements Streamable {
    private static final int NULL = 0;
    private static final int NOT_NULL = 1;
    private ClientConnectionDelegate delegate;
    private int actualFailoverNodeID;

    public CreateConnectionResult() {
    }

    public CreateConnectionResult(ClientConnectionDelegate delegate) {
        this(delegate, Integer.MIN_VALUE);
    }

    public CreateConnectionResult(int actualFailoverNodeID) {
        this(null, actualFailoverNodeID);
    }

    private CreateConnectionResult(ClientConnectionDelegate delegate, int actualFailoverNodeId) {
        this.delegate = delegate;
        this.actualFailoverNodeID = actualFailoverNodeId;
    }

    public ClientConnectionDelegate getDelegate() {
        return this.delegate;
    }

    public int getActualFailoverNodeID() {
        return this.actualFailoverNodeID;
    }

    public String toString() {
        return "CreateConnectionResult[" + this.delegate + ", failover node " + this.actualFailoverNodeID + "]";
    }

    public void read(DataInputStream in) throws Exception {
        this.actualFailoverNodeID = in.readInt();
        byte b = in.readByte();
        if (b == 1) {
            this.delegate = new ClientConnectionDelegate();
            this.delegate.read(in);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.actualFailoverNodeID);
        if (this.delegate == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.delegate.write(out);
        }
    }
}

