/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jboss.kernel.plugins.AbstractKernelObject;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.util.CollectionsFactory;

public abstract class AbstractKernelRegistry
extends AbstractKernelObject
implements KernelRegistry {
    protected List factories = CollectionsFactory.createCopyOnWriteList();

    public void addKernelRegistryFactory(KernelRegistryPlugin kernelRegistryPlugin) {
        this.factories.add(kernelRegistryPlugin);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registry " + this + " added registry factory " + kernelRegistryPlugin));
        }
    }

    public void removeKernelRegistryFactory(KernelRegistryPlugin kernelRegistryPlugin) {
        this.factories.remove(kernelRegistryPlugin);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registry " + this + " removed registry factory " + kernelRegistryPlugin));
        }
    }

    public KernelRegistryEntry getEntry(Object object) {
        ListIterator listIterator = this.factories.listIterator();
        while (listIterator.hasNext()) {
            KernelRegistryPlugin kernelRegistryPlugin = (KernelRegistryPlugin)listIterator.next();
            KernelRegistryEntry kernelRegistryEntry = kernelRegistryPlugin.getEntry(object);
            if (kernelRegistryEntry == null) continue;
            return kernelRegistryEntry;
        }
        throw new KernelRegistryEntryNotFoundException("Entry not found with name: " + object);
    }

    public boolean containsEntry(Object object) {
        Iterator iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            KernelRegistryPlugin kernelRegistryPlugin = (KernelRegistryPlugin)iterator.next();
            KernelRegistryEntry kernelRegistryEntry = kernelRegistryPlugin.getEntry(object);
            if (kernelRegistryEntry == null) continue;
            return true;
        }
        return false;
    }
}

