/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.plugins.spi.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.logging.Logger;

public class KernelControllerContextActions
extends AbstractControllerContextActions {
    private static KernelControllerContextActions instance;

    protected static Object dispatchJoinPoint(KernelControllerContext kernelControllerContext, Joinpoint joinpoint) throws Throwable {
        Object object;
        AccessControlContext accessControlContext = null;
        if (kernelControllerContext instanceof AbstractKernelControllerContext) {
            object = (AbstractKernelControllerContext)kernelControllerContext;
            accessControlContext = ((AbstractKernelControllerContext)object).getAccessControlContext();
        }
        if (accessControlContext == null) {
            return joinpoint.dispatch();
        }
        object = new DispatchJoinPoint(joinpoint);
        try {
            return AccessController.doPrivileged(object, accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getCause();
        }
    }

    public static KernelControllerContextActions getInstance() {
        if (instance == null) {
            HashMap<ControllerState, KernelControllerContextAction> hashMap = new HashMap<ControllerState, KernelControllerContextAction>();
            hashMap.put(ControllerState.DESCRIBED, new DescribeAction());
            hashMap.put(ControllerState.INSTANTIATED, new InstantiateAction());
            hashMap.put(ControllerState.CONFIGURED, new ConfigureAction());
            hashMap.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
            hashMap.put(ControllerState.START, new StartStopLifecycleAction());
            hashMap.put(ControllerState.INSTALLED, new InstallAction());
            instance = new KernelControllerContextActions(hashMap);
        }
        return instance;
    }

    protected KernelControllerContextActions(Map map) {
        super(map);
    }

    private static class DispatchJoinPoint
    implements PrivilegedExceptionAction {
        private Joinpoint joinpoint;

        public DispatchJoinPoint(Joinpoint joinpoint) {
            this.joinpoint = joinpoint;
        }

        public Object run() throws Exception {
            try {
                return this.joinpoint.dispatch();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public static class InstallAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelRegistry kernelRegistry = kernel.getRegistry();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            String string = beanMetaData.getName();
            kernelRegistry.registerEntry(string, kernelControllerContext);
            kernelController.addSupplies(kernelControllerContext);
        }

        public void uninstallAction(KernelControllerContext kernelControllerContext) {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelRegistry kernelRegistry = kernel.getRegistry();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            String string = beanMetaData.getName();
            try {
                kernelController.removeSupplies(kernelControllerContext);
                kernelRegistry.unregisterEntry(string);
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("Ignoring unregistered entry at uninstall " + string));
            }
        }
    }

    public static class StartStopLifecycleAction
    extends LifecycleAction {
        public String getInstallMethod(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getStart();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getMethodName();
            }
            return "start";
        }

        public List getInstallParameters(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getStart();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getParameters();
            }
            return null;
        }

        public String getUninstallMethod(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getStop();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getMethodName();
            }
            return "stop";
        }

        public List getUninstallParameters(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getStop();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getParameters();
            }
            return null;
        }
    }

    public static class CreateDestroyLifecycleAction
    extends LifecycleAction {
        public String getInstallMethod(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getCreate();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getMethodName();
            }
            return "create";
        }

        public List getInstallParameters(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getCreate();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getParameters();
            }
            return null;
        }

        public String getUninstallMethod(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getDestroy();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getMethodName();
            }
            return "destroy";
        }

        public List getUninstallParameters(KernelControllerContext kernelControllerContext) {
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            LifecycleMetaData lifecycleMetaData = beanMetaData.getDestroy();
            if (lifecycleMetaData != null) {
                return lifecycleMetaData.getParameters();
            }
            return null;
        }
    }

    public static abstract class LifecycleAction
    extends KernelControllerContextAction {
        public abstract String getInstallMethod(KernelControllerContext var1);

        public abstract List getInstallParameters(KernelControllerContext var1);

        public abstract String getUninstallMethod(KernelControllerContext var1);

        public abstract List getUninstallParameters(KernelControllerContext var1);

        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
            boolean bl = this.log.isTraceEnabled();
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            Object object = kernelControllerContext.getTarget();
            BeanInfo beanInfo = kernelControllerContext.getBeanInfo();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            String string = this.getInstallMethod(kernelControllerContext);
            List list = this.getInstallParameters(kernelControllerContext);
            MethodJoinpoint methodJoinpoint = null;
            try {
                ClassLoader classLoader = Configurator.getClassLoader(beanMetaData);
                methodJoinpoint = kernelConfigurator.getMethodJoinPoint(beanInfo, classLoader, string, list, false, true);
            }
            catch (JoinpointException joinpointException) {
                if (bl) {
                    if (list == null) {
                        this.log.trace((Object)("No " + string + " method for " + kernelControllerContext));
                    } else {
                        this.log.trace((Object)("No " + string + list + " method for " + kernelControllerContext));
                    }
                }
                return;
            }
            methodJoinpoint.setTarget(object);
            KernelControllerContextActions.dispatchJoinPoint(kernelControllerContext, (Joinpoint)methodJoinpoint);
        }

        public void uninstallAction(KernelControllerContext kernelControllerContext) {
            boolean bl = this.log.isTraceEnabled();
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            Object object = kernelControllerContext.getTarget();
            BeanInfo beanInfo = kernelControllerContext.getBeanInfo();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            String string = this.getUninstallMethod(kernelControllerContext);
            List list = this.getUninstallParameters(kernelControllerContext);
            MethodJoinpoint methodJoinpoint = null;
            try {
                ClassLoader classLoader = Configurator.getClassLoader(beanMetaData);
                methodJoinpoint = kernelConfigurator.getMethodJoinPoint(beanInfo, classLoader, string, list, false, true);
                methodJoinpoint.setTarget(object);
                KernelControllerContextActions.dispatchJoinPoint(kernelControllerContext, (Joinpoint)methodJoinpoint);
            }
            catch (JoinpointException joinpointException) {
                if (bl) {
                    if (list == null) {
                        this.log.trace((Object)("No " + string + " method for " + kernelControllerContext));
                    } else {
                        this.log.trace((Object)("No " + string + list + " method for " + kernelControllerContext));
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("Error during " + string), throwable);
            }
        }
    }

    public static class ConfigureAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            Object object = kernelControllerContext.getTarget();
            BeanInfo beanInfo = kernelControllerContext.getBeanInfo();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            Set set = kernelConfigurator.getPropertySetterJoinPoints(beanInfo, beanMetaData);
            this.setAttributes(kernelControllerContext, object, set, false);
        }

        public void uninstallAction(KernelControllerContext kernelControllerContext) {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            Object object = kernelControllerContext.getTarget();
            BeanInfo beanInfo = kernelControllerContext.getBeanInfo();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            try {
                Set set = kernelConfigurator.getPropertyNullerJoinPoints(beanInfo, beanMetaData);
                this.setAttributes(kernelControllerContext, object, set, true);
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("Error unconfiguring bean " + kernelControllerContext), throwable);
            }
        }

        protected void setAttributes(KernelControllerContext kernelControllerContext, Object object, Set set, boolean bl) throws Throwable {
            if (!set.isEmpty()) {
                boolean bl2 = this.log.isTraceEnabled();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    TargettedJoinpoint targettedJoinpoint = (TargettedJoinpoint)iterator.next();
                    targettedJoinpoint.setTarget(object);
                    try {
                        KernelControllerContextActions.dispatchJoinPoint(kernelControllerContext, (Joinpoint)targettedJoinpoint);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            if (!bl2) continue;
                            this.log.trace((Object)("Ignored for " + targettedJoinpoint), throwable);
                            continue;
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public static class InstantiateAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            BeanInfo beanInfo = kernelControllerContext.getBeanInfo();
            Joinpoint joinpoint = kernelConfigurator.getConstructorJoinPoint(beanInfo, beanMetaData.getConstructor(), beanMetaData);
            Object object = KernelControllerContextActions.dispatchJoinPoint(kernelControllerContext, joinpoint);
            kernelControllerContext.setTarget(object);
            try {
                if (object != null && object instanceof KernelControllerContextAware) {
                    ((KernelControllerContextAware)object).setKernelControllerContext(kernelControllerContext);
                }
            }
            catch (Throwable throwable) {
                this.uninstall(kernelControllerContext);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uninstallAction(KernelControllerContext kernelControllerContext) {
            try {
                Object object = kernelControllerContext.getTarget();
                if (object != null && object instanceof KernelControllerContextAware) {
                    ((KernelControllerContextAware)object).unsetKernelControllerContext(kernelControllerContext);
                }
            }
            catch (Throwable throwable) {
                this.log.debug((Object)"Ignored error unsetting context ", throwable);
            }
            finally {
                kernelControllerContext.setTarget(null);
            }
        }
    }

    public static class DescribeAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
            KernelController kernelController = (KernelController)kernelControllerContext.getController();
            Kernel kernel = kernelController.getKernel();
            KernelConfigurator kernelConfigurator = kernel.getConfigurator();
            BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
            BeanInfo beanInfo = kernelConfigurator.getBeanInfo(beanMetaData);
            kernelControllerContext.setBeanInfo(beanInfo);
            DependencyInfo dependencyInfo = kernelControllerContext.getDependencyInfo();
            List list = beanInfo.getDependencies();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AbstractDependencyItem abstractDependencyItem = new AbstractDependencyItem((Object)beanMetaData.getName(), iterator.next(), ControllerState.INSTANTIATED, ControllerState.INSTALLED);
                    dependencyInfo.addIDependOn((DependencyItem)abstractDependencyItem);
                }
            }
        }

        public void uninstallAction(KernelControllerContext kernelControllerContext) {
            kernelControllerContext.setBeanInfo(null);
        }
    }

    public static class KernelControllerContextAction
    implements ControllerContextAction {
        protected Logger log = Logger.getLogger(this.getClass());

        public void install(final ControllerContext controllerContext) throws Throwable {
            if (System.getSecurityManager() == null || !(controllerContext instanceof AbstractKernelControllerContext)) {
                this.installAction((KernelControllerContext)controllerContext);
            } else {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            KernelControllerContextAction.this.installAction((KernelControllerContext)controllerContext);
                            return null;
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        catch (Error error) {
                            throw error;
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                    }
                };
                try {
                    AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getCause();
                }
            }
        }

        public void uninstall(final ControllerContext controllerContext) {
            if (System.getSecurityManager() == null || !(controllerContext instanceof AbstractKernelControllerContext)) {
                this.uninstallAction((KernelControllerContext)controllerContext);
            } else {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        KernelControllerContextAction.this.uninstallAction((KernelControllerContext)controllerContext);
                        return null;
                    }
                };
                AccessController.doPrivileged(privilegedAction);
            }
        }

        public void installAction(KernelControllerContext kernelControllerContext) throws Throwable {
        }

        public void uninstallAction(KernelControllerContext kernelControllerContext) {
        }
    }
}

