/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.calendar;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.calendar.FunctionCallProvider;
import org.apache.myfaces.custom.calendar.HtmlInputCalendar;
import org.apache.myfaces.custom.inputTextHelp.HtmlInputTextHelp;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.renderkit.html.util.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public class HtmlCalendarRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer));
    private static final String JAVASCRIPT_ENCODED = "org.apache.myfaces.calendar.JAVASCRIPT_ENCODED";
    static /* synthetic */ Class class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$calendar$HtmlInputCalendar;
    static /* synthetic */ Class class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader;

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Date value;
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        HtmlInputCalendar inputCalendar = (HtmlInputCalendar)component;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        try {
            Converter converter = this.getConverter((UIInput)inputCalendar);
            value = converter instanceof DateConverter ? ((DateConverter)converter).getAsDate(facesContext, component) : RendererUtils.getDateValue((UIComponent)inputCalendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            value = null;
        }
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = HtmlCalendarRenderer.mapShortWeekdays(symbols);
        String[] months = HtmlCalendarRenderer.mapMonths(symbols);
        if (inputCalendar.isRenderAsPopup()) {
            if (inputCalendar.isAddResources()) {
                HtmlCalendarRenderer.addScriptAndCSSResources(facesContext, component);
            }
            UIInput uiInput = (UIInput)component;
            Converter converter = uiInput.getConverter();
            String dateFormat = null;
            if (converter != null && converter instanceof DateTimeConverter) {
                dateFormat = ((DateTimeConverter)converter).getPattern();
            }
            if (dateFormat == null) {
                dateFormat = CalendarDateTimeConverter.createJSPopupFormat(facesContext, inputCalendar.getPopupDateFormat());
            }
            Application application = facesContext.getApplication();
            HtmlInputTextHelp inputText = this.getOrCreateInputTextChild(inputCalendar, application);
            RendererUtils.copyHtmlInputTextAttributes(inputCalendar, inputText);
            inputText.setConverter(null);
            inputText.setTransient(true);
            inputText.setHelpText(inputCalendar.getHelpText());
            inputText.setSelectText(true);
            if (value == null && inputCalendar.getSubmittedValue() != null) {
                inputText.setValue(inputCalendar.getSubmittedValue());
            } else {
                inputText.setValue(this.getConverter((UIInput)inputCalendar).getAsString(facesContext, (UIComponent)inputCalendar, (Object)value));
            }
            inputText.setDisabled(inputCalendar.isDisabled());
            inputText.setReadonly(inputCalendar.isReadonly());
            inputText.setEnabledOnUserRole(inputCalendar.getEnabledOnUserRole());
            inputText.setVisibleOnUserRole(inputCalendar.getVisibleOnUserRole());
            inputCalendar.setId(inputCalendar.getId() + "tempId");
            inputCalendar.getChildren().add(inputText);
            RendererUtils.renderChild(facesContext, (UIComponent)inputText);
            inputCalendar.getChildren().remove(inputText);
            inputCalendar.setId(inputText.getId());
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("span", (UIComponent)inputCalendar);
            writer.writeAttribute("id", (Object)(inputCalendar.getClientId(facesContext) + "Span"), "id");
            writer.endElement("span");
            if (!inputCalendar.isDisabled()) {
                writer.startElement("script", component);
                writer.writeAttribute("type", (Object)"text/javascript", null);
                String calendarVar = JavascriptUtils.getValidJavascriptName(inputCalendar.getClientId(facesContext) + "CalendarVar", false);
                writer.writeText((Object)("var " + calendarVar + "=new org_apache_myfaces_PopupCalendar();\n"), null);
                writer.writeText((Object)(HtmlCalendarRenderer.getLocalizedLanguageScript(facesContext, symbols, timeKeeper.getFirstDayOfWeek(), (UIComponent)inputCalendar, calendarVar) + "\n"), null);
                writer.writeText((Object)(calendarVar + ".init(document.getElementById('" + inputCalendar.getClientId(facesContext) + "Span" + "'));\n"), null);
                if (!inputCalendar.isDisplayValueOnly()) {
                    writer.writeText((Object)(HtmlCalendarRenderer.getScriptBtn(facesContext, (UIComponent)inputCalendar, dateFormat, inputCalendar.getPopupButtonString(), new FunctionCallProvider(){

                        public String getFunctionCall(FacesContext facesContext, UIComponent uiComponent, String dateFormat) {
                            String clientId = uiComponent.getClientId(facesContext);
                            String clientVar = JavascriptUtils.getValidJavascriptName(clientId + "CalendarVar", true);
                            return clientVar + "._popUpCalendar(this,document.getElementById(\\'" + clientId + "\\'),\\'" + dateFormat + "\\')";
                        }
                    }) + "\n"), null);
                }
                writer.endElement("script");
            }
        } else {
            int lastDayInMonth = timeKeeper.getActualMaximum(5);
            int currentDay = timeKeeper.get(5);
            if (currentDay > lastDayInMonth) {
                currentDay = lastDayInMonth;
            }
            timeKeeper.set(5, 1);
            int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
            int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
            ResponseWriter writer = facesContext.getResponseWriter();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("table", component);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.EVENT_HANDLER_ATTRIBUTES);
            writer.flush();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getMonthYearRowClass() != null) {
                writer.writeAttribute("class", (Object)inputCalendar.getMonthYearRowClass(), null);
            }
            this.writeMonthYearHeader(facesContext, writer, (UIInput)inputCalendar, timeKeeper, currentDay, weekdays, months);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getWeekRowClass() != null) {
                writer.writeAttribute("class", (Object)inputCalendar.getWeekRowClass(), null);
            }
            this.writeWeekDayNameHeader(weekStartsAtDayIndex, weekdays, facesContext, writer, (UIInput)inputCalendar);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            this.writeDays(facesContext, writer, inputCalendar, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, weekdays);
            writer.endElement("table");
        }
    }

    private HtmlInputTextHelp getOrCreateInputTextChild(HtmlInputCalendar inputCalendar, Application application) {
        HtmlInputTextHelp inputText = null;
        List li = inputCalendar.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent uiComponent = (UIComponent)li.get(i);
            if (!(uiComponent instanceof HtmlInputTextHelp)) continue;
            inputText = (HtmlInputTextHelp)uiComponent;
            break;
        }
        if (inputText == null) {
            inputText = (HtmlInputTextHelp)application.createComponent("org.apache.myfaces.HtmlInputTextHelp");
        }
        return inputText;
    }

    public static void addScriptAndCSSResources(FacesContext facesContext, UIComponent component) {
        if (facesContext.getExternalContext().getRequestMap().containsKey(JAVASCRIPT_ENCODED)) {
            return;
        }
        AddResource addresource = AddResourceFactory.getInstance(facesContext);
        String styleLocation = HtmlRendererUtils.getStyleLocation(component);
        if (styleLocation == null) {
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "WH/theme.css");
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "DB/theme.css");
        } else {
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, styleLocation + "/theme.css");
        }
        String javascriptLocation = HtmlRendererUtils.getJavascriptLocation(component);
        if (javascriptLocation == null) {
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader == null ? (class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.prototype.PrototypeResourceLoader")) : class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader, "prototype.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "date.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "popcalendar.js");
        } else {
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/prototype.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/date.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/popcalendar.js");
        }
        facesContext.getExternalContext().getRequestMap().put(JAVASCRIPT_ENCODED, Boolean.TRUE);
    }

    public static String getLocalizedLanguageScript(FacesContext facesContext, DateFormatSymbols symbols, int firstDayOfWeek, UIComponent uiComponent, String popupCalendarVariable) {
        String[] weekDays;
        int realFirstDayOfWeek = firstDayOfWeek - 1;
        if (realFirstDayOfWeek == 0) {
            weekDays = HtmlCalendarRenderer.mapShortWeekdaysStartingWithSunday(symbols);
        } else if (realFirstDayOfWeek == 1) {
            weekDays = HtmlCalendarRenderer.mapShortWeekdays(symbols);
        } else {
            throw new IllegalStateException("Week may only start with sunday or monday.");
        }
        StringBuffer script = new StringBuffer();
        HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.imgDir", JavascriptUtils.encodeString(AddResourceFactory.getInstance(facesContext).getResourceUri(facesContext, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "DB/")));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".initData.monthName", HtmlCalendarRenderer.mapMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".initData.dayName", weekDays);
        HtmlCalendarRenderer.setIntegerVariable(script, popupCalendarVariable + ".initData.startAt", realFirstDayOfWeek);
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.weekdays", HtmlCalendarRenderer.mapWeekdaysStartingWithSunday(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.shortWeekdays", HtmlCalendarRenderer.mapShortWeekdaysStartingWithSunday(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.shortMonths", HtmlCalendarRenderer.mapShortMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.months", HtmlCalendarRenderer.mapMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.eras", symbols.getEras());
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.ampms", symbols.getAmPmStrings());
        if (uiComponent instanceof HtmlInputCalendar) {
            HtmlInputCalendar inputCalendar = (HtmlInputCalendar)uiComponent;
            if (inputCalendar.getPopupGotoString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.gotoString", inputCalendar.getPopupGotoString());
            }
            if (inputCalendar.getPopupTodayString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayString", inputCalendar.getPopupTodayString());
            }
            if (inputCalendar.getPopupTodayDateFormat() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayDateFormat", inputCalendar.getPopupTodayDateFormat());
            } else if (inputCalendar.getPopupDateFormat() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayDateFormat", inputCalendar.getPopupDateFormat());
            }
            if (inputCalendar.getPopupWeekString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.weekString", inputCalendar.getPopupWeekString());
            }
            if (inputCalendar.getPopupScrollLeftMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.scrollLeftMessage", inputCalendar.getPopupScrollLeftMessage());
            }
            if (inputCalendar.getPopupScrollRightMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.scrollRightMessage", inputCalendar.getPopupScrollRightMessage());
            }
            if (inputCalendar.getPopupSelectMonthMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectMonthMessage", inputCalendar.getPopupSelectMonthMessage());
            }
            if (inputCalendar.getPopupSelectYearMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectYearMessage", inputCalendar.getPopupSelectYearMessage());
            }
            if (inputCalendar.getPopupSelectDateMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectDateMessage", inputCalendar.getPopupSelectDateMessage());
            }
            HtmlCalendarRenderer.setBooleanVariable(script, popupCalendarVariable + ".initData.popupLeft", inputCalendar.isPopupLeft());
        }
        return script.toString();
    }

    private static void setBooleanVariable(StringBuffer script, String name, boolean value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setIntegerVariable(StringBuffer script, String name, int value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setStringVariable(StringBuffer script, String name, String value) {
        script.append(name);
        script.append(" = \"");
        script.append(StringEscapeUtils.escapeJavaScript((String)value));
        script.append("\";\n");
    }

    private static void defineStringArray(StringBuffer script, String arrayName, String[] array) {
        script.append(arrayName);
        script.append(" = new Array(");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                script.append(",");
            }
            script.append("\"");
            script.append(StringEscapeUtils.escapeJavaScript((String)array[i]));
            script.append("\"");
        }
        script.append(");\n");
    }

    public static String getScriptBtn(FacesContext facesContext, UIComponent uiComponent, String dateFormat, String popupButtonString, FunctionCallProvider prov) throws IOException {
        HtmlBufferResponseWriterWrapper writer = HtmlBufferResponseWriterWrapper.getInstance(facesContext.getResponseWriter());
        boolean renderButtonAsImage = false;
        String popupButtonStyle = null;
        String popupButtonStyleClass = null;
        if (uiComponent instanceof HtmlInputCalendar) {
            HtmlInputCalendar calendar = (HtmlInputCalendar)uiComponent;
            renderButtonAsImage = calendar.isRenderPopupButtonAsImage();
            popupButtonStyle = calendar.getPopupButtonStyle();
            popupButtonStyleClass = calendar.getPopupButtonStyleClass();
        }
        writer.write("\nif (!document.layers) {\n");
        writer.write("document.write('");
        if (!renderButtonAsImage) {
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", "button", null);
            writer.writeAttribute("onclick", prov.getFunctionCall(facesContext, uiComponent, dateFormat), null);
            if (popupButtonString == null) {
                popupButtonString = "...";
            }
            writer.writeAttribute("value", StringEscapeUtils.escapeJavaScript((String)popupButtonString), null);
            if (popupButtonStyle != null) {
                writer.writeAttribute("style", popupButtonStyle, null);
            }
            if (popupButtonStyleClass != null) {
                writer.writeAttribute("class", popupButtonStyleClass, null);
            }
            writer.endElement("input");
        } else {
            writer.startElement("img", uiComponent);
            AddResource addResource = AddResourceFactory.getInstance(facesContext);
            String imgUrl = (String)uiComponent.getAttributes().get("popupButtonImageUrl");
            if (imgUrl != null) {
                writer.writeAttribute("src", addResource.getResourceUri(facesContext, imgUrl), null);
            } else {
                writer.writeAttribute("src", addResource.getResourceUri(facesContext, class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "images/calendar.gif"), null);
            }
            if (popupButtonStyle != null) {
                writer.writeAttribute("style", popupButtonStyle, null);
            } else {
                writer.writeAttribute("style", "vertical-align:bottom;", null);
            }
            if (popupButtonStyleClass != null) {
                writer.writeAttribute("class", popupButtonStyleClass, null);
            }
            writer.writeAttribute("onclick", prov.getFunctionCall(facesContext, uiComponent, dateFormat), null);
            writer.endElement("img");
        }
        writer.write("');");
        writer.write("\n}");
        return writer.toString();
    }

    private void writeMonthYearHeader(FacesContext facesContext, ResponseWriter writer, UIInput inputComponent, Calendar timeKeeper, int currentDay, String[] weekdays, String[] months) throws IOException {
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(facesContext, writer, inputComponent, "<", cal.getTime(), null);
        writer.startElement("td", (UIComponent)inputComponent);
        writer.writeAttribute("colspan", (Object)new Integer(weekdays.length - 2), null);
        writer.writeText((Object)(months[timeKeeper.get(2)] + " " + timeKeeper.get(1)), null);
        writer.endElement("td");
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(facesContext, writer, inputComponent, ">", cal.getTime(), null);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(5, 1);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = Calendar.getInstance(facesContext.getViewRoot().getLocale());
        cal.set(1, timeKeeper.get(1));
        cal.set(2, timeKeeper.get(2));
        cal.set(11, timeKeeper.get(11));
        cal.set(12, timeKeeper.get(12));
        cal.set(13, timeKeeper.get(13));
        cal.set(14, timeKeeper.get(14));
        return cal;
    }

    private void writeWeekDayNameHeader(int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, UIInput inputComponent) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
    }

    private void writeDays(FacesContext facesContext, ResponseWriter writer, HtmlInputCalendar inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekdays) throws IOException {
        int i;
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        for (i = 0; i < space; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            ++columnIndexCounter;
        }
        for (i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i + 1);
            String cellStyle = inputComponent.getDayCellClass();
            if (currentDay - 1 == i) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle);
            if (++columnIndexCounter != weekdays.length) continue;
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            columnIndexCounter = 0;
        }
        if (columnIndexCounter != 0) {
            for (i = columnIndexCounter; i < weekdays.length; ++i) {
                this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            }
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        }
    }

    private void writeCell(FacesContext facesContext, ResponseWriter writer, UIInput component, String content, Date valueForLink, String styleClass) throws IOException {
        writer.startElement("td", (UIComponent)component);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (valueForLink == null) {
            writer.writeText((Object)content, "value");
        } else {
            this.writeLink(content, component, facesContext, valueForLink);
        }
        writer.endElement("td");
    }

    private void writeLink(String content, UIInput component, FacesContext facesContext, Date valueForLink) throws IOException {
        Converter converter = this.getConverter(component);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(component.getId() + "_" + valueForLink.getTime() + "_link");
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        HtmlOutputText text = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        text.setValue((Object)content);
        text.setId(component.getId() + "_" + valueForLink.getTime() + "_text");
        text.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue((Object)converter.getAsString(facesContext, (UIComponent)component, (Object)valueForLink));
        HtmlInputCalendar calendar = (HtmlInputCalendar)component;
        if (calendar.isDisabled() || calendar.isReadonly()) {
            component.getChildren().add(text);
            RendererUtils.renderChild(facesContext, (UIComponent)text);
        } else {
            RendererUtils.addOrReplaceChild(component, (UIComponent)link);
            link.getChildren().add(parameter);
            link.getChildren().add(text);
            RendererUtils.renderChild(facesContext, (UIComponent)link);
        }
    }

    private Converter getConverter(UIInput component) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        return converter;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static String[] mapShortWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private static String[] mapShortWeekdaysStartingWithSunday(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    private static String[] mapWeekdaysStartingWithSunday(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    public static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public static String[] mapShortMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getShortMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        String helperString = HtmlCalendarRenderer.getHelperString(component);
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramMap.containsKey(clientId)) {
            String value = (String)paramMap.get(clientId);
            if (!value.equalsIgnoreCase(helperString)) {
                ((EditableValueHolder)component).setSubmittedValue((Object)value);
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)"");
            }
        } else {
            log.warn((Object)("There should always be a submitted value for an input if it is rendered, its form is submitted, and it is not disabled or read-only. Component : " + RendererUtils.getPathToComponent(component)));
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        UIInput uiInput = (UIInput)uiComponent;
        Converter converter = uiInput.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        return converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
    }

    private static String getHelperString(UIComponent uiComponent) {
        return uiComponent instanceof HtmlInputCalendar ? ((HtmlInputCalendar)uiComponent).getHelpText() : null;
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("M/d/yy h:mm a");
        System.out.println(format.get2DigitYearStart());
        System.out.println(format.format(format.parse("10/10/2005 6:00 AM")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CalendarDateTimeConverter
    implements DateConverter {
        private static final String CONVERSION_MESSAGE_ID = "org.apache.myfaces.calendar.CONVERSION";

        public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
            SimpleDateFormat dateFormat;
            if (s == null || s.trim().length() == 0 || s.equals(HtmlCalendarRenderer.getHelperString(uiComponent))) {
                return null;
            }
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            dateFormat.setLenient(false);
            try {
                return dateFormat.parse(s);
            }
            catch (ParseException e) {
                FacesMessage msg = MessageUtils.getMessage(CONVERSION_MESSAGE_ID, new Object[]{uiComponent.getId(), s});
                throw new ConverterException(msg, (Throwable)e);
            }
        }

        public Date getAsDate(FacesContext facesContext, UIComponent uiComponent) {
            return RendererUtils.getDateValue(uiComponent);
        }

        public static String createJSPopupFormat(FacesContext facesContext, String popupDateFormat) {
            if (popupDateFormat == null) {
                SimpleDateFormat defaultDateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
                popupDateFormat = defaultDateFormat.toPattern();
            }
            return popupDateFormat;
        }

        public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
            SimpleDateFormat dateFormat;
            Date date = (Date)o;
            if (date == null) {
                return HtmlCalendarRenderer.getHelperString(uiComponent);
            }
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            dateFormat.setLenient(false);
            return dateFormat.format(date);
        }

        private static SimpleDateFormat createStandardDateFormat(FacesContext facesContext) {
            DateFormat dateFormat = DateFormat.getDateInstance(3, facesContext.getViewRoot().getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                return (SimpleDateFormat)dateFormat;
            }
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    }

    public static interface DateConverter
    extends Converter {
        public Date getAsDate(FacesContext var1, UIComponent var2);
    }
}

