/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CachedSetImpl;
import org.jboss.cache.aop.collection.CollectionInterceptorUtil;

public class CachedSetInterceptor
extends AbstractCollectionInterceptor {
    protected Map methodMap_;
    protected static final Map managedMethods_ = CollectionInterceptorUtil.getManagedMethods(Set.class);
    protected Set cacheImpl_;
    protected Set current_;
    protected Set inMemImpl_;

    public CachedSetInterceptor(PojoCache cache, Fqn fqn, Class clazz, Set obj) {
        this.fqn_ = fqn;
        this.methodMap_ = CollectionInterceptorUtil.getMethodMap(clazz);
        this.cacheImpl_ = new CachedSetImpl(cache, this);
        this.inMemImpl_ = obj;
        this.current_ = this.cacheImpl_;
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        super.attach(fqn, copyToCache);
        if (copyToCache) {
            this.toCache();
        }
        this.current_ = this.cacheImpl_;
    }

    protected void toCache() {
        if (this.inMemImpl_ == null) {
            throw new IllegalStateException("CachedSetInterceptor.toCache(). inMemImpl is null.");
        }
        Iterator it = this.inMemImpl_.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            it.remove();
            this.cacheImpl_.add(obj);
        }
    }

    public void detach(boolean removeFromCache) {
        super.detach(removeFromCache);
        this.toMemory(removeFromCache);
        this.current_ = this.inMemImpl_;
    }

    protected void toMemory(boolean removeFromCache) {
        if (this.inMemImpl_ == null) {
            this.inMemImpl_ = new HashSet();
        }
        this.inMemImpl_.clear();
        Iterator it = this.cacheImpl_.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (removeFromCache) {
                it.remove();
            }
            this.inMemImpl_.add(obj);
        }
    }

    public String getName() {
        return "CachedSetInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.current_ == null) {
            throw new IllegalStateException("CachedSetInterceptor.invoke(). current_ is null.");
        }
        return CollectionInterceptorUtil.invoke(invocation, this.current_, this.methodMap_, managedMethods_);
    }

    public Object getOriginalInstance() {
        return this.inMemImpl_;
    }
}

