/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.util.Config;

public class ConnectionManager {
    private static Log log = LogFactory.getLog((Class)ConnectionManager.class);
    private static DataSource dataSource = null;

    public static Connection aquireConnection() throws SQLException {
        if (dataSource == null) {
            dataSource = ConnectionManager.lookupDataSource();
        }
        Connection conn = null;
        if (dataSource != null) {
            conn = dataSource.getConnection();
        }
        return conn;
    }

    private static synchronized DataSource lookupDataSource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        try {
            String dataSourceName = Config.getStringProperty("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
            log.info((Object)("Using JNDI to aquire a JDBC DataSource with name: " + dataSourceName));
            InitialContext initCtx = new InitialContext();
            dataSource = (DataSource)initCtx.lookup(dataSourceName);
        }
        catch (NamingException nex) {
            log.error((Object)("Exception occurred while attempting to acquire a JDBC DataSource from JNDI: " + nex.getMessage()));
        }
        return dataSource;
    }
}

