/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.datatype.response.KeysOwned;

class PublisherAssertionTable {
    private static Log log = LogFactory.getLog((Class)PublisherAssertionTable.class);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteDeadAssertionsSQL = null;
    static String updateFromCheckSQL = null;
    static String updateToCheckSQL = null;
    static String updateFromCheckByFromKeySQL = null;
    static String updateToCheckByToKeySQL = null;
    static String selectAssertionsSQL = null;
    static String selectRelationships = null;

    PublisherAssertionTable() {
    }

    public static void insert(PublisherAssertion assertion, boolean fromCheck, boolean toCheck, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            String tModelKey = null;
            String keyedRefName = null;
            String keyedRefValue = null;
            if (assertion.getKeyedReference() != null) {
                tModelKey = assertion.getKeyedReference().getTModelKey();
                keyedRefName = assertion.getKeyedReference().getKeyName();
                keyedRefValue = assertion.getKeyedReference().getKeyValue();
            }
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, assertion.getFromKey());
            statement.setString(2, assertion.getToKey());
            statement.setString(3, tModelKey);
            statement.setString(4, keyedRefName);
            statement.setString(5, keyedRefValue);
            statement.setString(6, String.valueOf(fromCheck));
            statement.setString(7, String.valueOf(toCheck));
            log.debug((Object)("insert into PUBLISHER_ASSERTION table:\n\n\t" + insertSQL + "\n\t FROM_KEY=" + assertion.getFromKey() + "\n\t TO_KEY=" + assertion.getToKey() + "\n\t TMODEL_KEY=" + tModelKey + "\n\t KEY_NAME=" + keyedRefName + "\n\t KEY_VALUE=" + keyedRefValue + "\n\t FROM_CHECK=" + fromCheck + "\n\t TO_CHECK=" + toCheck + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static PublisherAssertion select(PublisherAssertion assertionIn, Connection connection) throws SQLException {
        PublisherAssertion assertionOut = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            KeyedReference keyedRefIn = assertionIn.getKeyedReference();
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, assertionIn.getFromKey());
            statement.setString(2, assertionIn.getToKey());
            statement.setString(3, keyedRefIn.getTModelKey());
            statement.setString(4, keyedRefIn.getKeyName());
            statement.setString(5, keyedRefIn.getKeyValue());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n\t FROM_KEY=" + assertionIn.getFromKey() + "\n\t TO_KEY=" + assertionIn.getToKey() + "\n\t TMODEL_KEY=" + keyedRefIn.getTModelKey() + "\n\t KEY_NAME=" + keyedRefIn.getKeyName() + "\n\t KEY_VALUE=" + keyedRefIn.getKeyValue() + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                KeyedReference keyedRefOut = new KeyedReference();
                keyedRefOut.setKeyName(resultSet.getString(4));
                keyedRefOut.setKeyValue(resultSet.getString(5));
                keyedRefOut.setTModelKey(resultSet.getString(3));
                assertionOut = new PublisherAssertion();
                assertionOut.setFromKey(resultSet.getString(1));
                assertionOut.setToKey(resultSet.getString(2));
                assertionOut.setKeyedReference(keyedRefOut);
            }
            PublisherAssertion publisherAssertion = assertionOut;
            return publisherAssertion;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void deleteDeadAssertions(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteDeadAssertionsSQL);
            log.debug((Object)("delete from PUBLISHER_ASSERTION table:\n\n\t" + deleteDeadAssertionsSQL + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void updateFromCheck(PublisherAssertion assertion, boolean fromCheck, Connection connection) throws SQLException {
        KeyedReference keyedRef = assertion.getKeyedReference();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            log.debug((Object)("update PUBLISHER_ASSERTION table:\n\n\t" + updateFromCheckSQL + "\n\t FROM_CHECK=" + String.valueOf(fromCheck) + "\n\t FROM_KEY=" + assertion.getFromKey() + "\n\t TO_KEY=" + assertion.getToKey() + "\n\t TMODEL_KEY=" + keyedRef.getTModelKey() + "\n\t KEY_NAME=" + keyedRef.getKeyName() + "\n\t KEY_VALUE=" + keyedRef.getKeyValue() + "\n"));
            statement = connection.prepareStatement(updateFromCheckSQL);
            statement.setString(1, String.valueOf(fromCheck));
            statement.setString(2, assertion.getFromKey());
            statement.setString(3, assertion.getToKey());
            statement.setString(4, keyedRef.getTModelKey());
            statement.setString(5, keyedRef.getKeyName());
            statement.setString(6, keyedRef.getKeyValue());
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void updateToCheck(PublisherAssertion assertion, boolean toCheck, Connection connection) throws SQLException {
        KeyedReference keyedRef = assertion.getKeyedReference();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            log.debug((Object)("update PUBLISHER_ASSERTION table:\n\n\t" + updateToCheckSQL + "\n\t TO_CHECK=" + String.valueOf(toCheck) + "\n\t FROM_KEY=" + assertion.getFromKey() + "\n\t TO_KEY=" + assertion.getToKey() + "\n\t TMODEL_KEY=" + keyedRef.getTModelKey() + "\n\t KEY_NAME=" + keyedRef.getKeyName() + "\n\t KEY_VALUE=" + keyedRef.getKeyValue() + "\n"));
            statement = connection.prepareStatement(updateToCheckSQL);
            statement.setString(1, String.valueOf(toCheck));
            statement.setString(2, assertion.getFromKey());
            statement.setString(3, assertion.getToKey());
            statement.setString(4, keyedRef.getTModelKey());
            statement.setString(5, keyedRef.getKeyName());
            statement.setString(6, keyedRef.getKeyValue());
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void updateFromCheckByFromKey(Vector fromKeysIn, boolean fromCheck, Connection connection) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(updateFromCheckByFromKeySQL);
        sql.append("WHERE FROM_KEY IN ");
        PublisherAssertionTable.appendIn(sql, fromKeysIn);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql.toString());
            statement.setString(1, String.valueOf(fromCheck));
            log.debug((Object)("update PUBLISHER_ASSERTION table:\n\n\t" + sql.toString() + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void updateToCheckByToKey(Vector toKeysIn, boolean toCheck, Connection connection) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(updateFromCheckByFromKeySQL);
        sql.append("WHERE TO_KEY IN ");
        PublisherAssertionTable.appendIn(sql, toKeysIn);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql.toString());
            statement.setString(1, String.valueOf(toCheck));
            log.debug((Object)("update PUBLISHER_ASSERTION table:\n\n\t" + sql.toString() + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Vector selectBothKeysOwnedAssertion(Vector keysIn, Connection connection) throws SQLException {
        if (keysIn == null || keysIn.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectAssertionsSQL);
        sql.append("WHERE FROM_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        sql.append("AND TO_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        Vector<Serializable> itemList = new Vector<Serializable>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Serializable item;
            statement = connection.prepareStatement(sql.toString());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                item = new AssertionStatusItem();
                ((AssertionStatusItem)item).setFromKey(resultSet.getString(1));
                ((AssertionStatusItem)item).setToKey(resultSet.getString(2));
                KeyedReference keyedRef = new KeyedReference();
                keyedRef.setTModelKey(resultSet.getString(3));
                keyedRef.setKeyName(resultSet.getString(4));
                keyedRef.setKeyValue(resultSet.getString(5));
                ((AssertionStatusItem)item).setKeyedReference(keyedRef);
                KeysOwned keysOwned = new KeysOwned();
                keysOwned.setFromKey(((AssertionStatusItem)item).getFromKey());
                keysOwned.setToKey(((AssertionStatusItem)item).getToKey());
                ((AssertionStatusItem)item).setKeysOwned(keysOwned);
                ((AssertionStatusItem)item).setCompletionStatus(new CompletionStatus("status:complete"));
                itemList.addElement(item);
            }
            item = itemList;
            return item;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Vector selectFromKeyOwnedAssertion(Vector keysIn, Connection connection) throws SQLException {
        if (keysIn == null || keysIn.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectAssertionsSQL);
        sql.append("WHERE FROM_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        sql.append("AND TO_KEY NOT IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        Vector<Serializable> itemList = new Vector<Serializable>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Serializable item;
            statement = connection.prepareStatement(sql.toString());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                item = new AssertionStatusItem();
                ((AssertionStatusItem)item).setFromKey(resultSet.getString(1));
                ((AssertionStatusItem)item).setToKey(resultSet.getString(2));
                KeyedReference keyedRef = new KeyedReference();
                keyedRef.setTModelKey(resultSet.getString(3));
                keyedRef.setKeyName(resultSet.getString(4));
                keyedRef.setKeyValue(resultSet.getString(5));
                ((AssertionStatusItem)item).setKeyedReference(keyedRef);
                KeysOwned keysOwned = new KeysOwned();
                keysOwned.setFromKey(((AssertionStatusItem)item).getFromKey());
                keysOwned.setToKey(null);
                ((AssertionStatusItem)item).setKeysOwned(keysOwned);
                CompletionStatus status = null;
                boolean fromCheck = new Boolean(resultSet.getString(6));
                boolean toCheck = new Boolean(resultSet.getString(7));
                if (fromCheck && toCheck) {
                    status = new CompletionStatus("status:complete");
                } else if (fromCheck && !toCheck) {
                    status = new CompletionStatus("status:toKey_incomplete");
                } else if (!fromCheck && toCheck) {
                    status = new CompletionStatus("status:fromKey_incomplete");
                }
                ((AssertionStatusItem)item).setCompletionStatus(status);
                itemList.addElement(item);
            }
            item = itemList;
            return item;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Vector selectToKeyOwnedAssertion(Vector keysIn, Connection connection) throws SQLException {
        if (keysIn == null || keysIn.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectAssertionsSQL);
        sql.append("WHERE FROM_KEY NOT IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        sql.append("AND TO_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        Vector<Serializable> itemList = new Vector<Serializable>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Serializable item;
            statement = connection.prepareStatement(sql.toString());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                item = new AssertionStatusItem();
                ((AssertionStatusItem)item).setFromKey(resultSet.getString(1));
                ((AssertionStatusItem)item).setToKey(resultSet.getString(2));
                KeyedReference keyedRef = new KeyedReference();
                keyedRef.setKeyName(resultSet.getString(4));
                keyedRef.setKeyValue(resultSet.getString(5));
                keyedRef.setTModelKey(resultSet.getString(3));
                ((AssertionStatusItem)item).setKeyedReference(keyedRef);
                KeysOwned keysOwned = new KeysOwned();
                keysOwned.setFromKey(null);
                keysOwned.setToKey(((AssertionStatusItem)item).getToKey());
                ((AssertionStatusItem)item).setKeysOwned(keysOwned);
                CompletionStatus status = null;
                boolean fromCheck = new Boolean(resultSet.getString(6));
                boolean toCheck = new Boolean(resultSet.getString(7));
                if (fromCheck && toCheck) {
                    status = new CompletionStatus("status:complete");
                } else if (fromCheck && !toCheck) {
                    status = new CompletionStatus("status:toKey_incomplete");
                } else if (!fromCheck && toCheck) {
                    status = new CompletionStatus("status:fromKey_incomplete");
                }
                ((AssertionStatusItem)item).setCompletionStatus(status);
                itemList.addElement(item);
            }
            item = itemList;
            return item;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Vector selectAssertions(Vector keysIn, Connection connection) throws SQLException {
        if (keysIn == null || keysIn.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectAssertionsSQL);
        sql.append("WHERE (FROM_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        sql.append("AND FROM_CHECK = 'true') ");
        sql.append("OR (TO_KEY IN ");
        PublisherAssertionTable.appendIn(sql, keysIn);
        sql.append("AND TO_CHECK = 'true')");
        Vector<Serializable> assertionList = new Vector<Serializable>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Serializable assertion;
            statement = connection.prepareStatement(sql.toString());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                assertion = new PublisherAssertion();
                ((PublisherAssertion)assertion).setFromKey(resultSet.getString(1));
                ((PublisherAssertion)assertion).setToKey(resultSet.getString(2));
                KeyedReference keyedRef = new KeyedReference();
                keyedRef.setKeyName(resultSet.getString(4));
                keyedRef.setKeyValue(resultSet.getString(5));
                keyedRef.setTModelKey(resultSet.getString(3));
                ((PublisherAssertion)assertion).setKeyedReference(keyedRef);
                assertionList.addElement(assertion);
            }
            assertion = assertionList;
            return assertion;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Vector selectRelatedBusinesses(String businessKey, String relatedKey, Connection connection) throws SQLException {
        Vector<Serializable> refList = new Vector<Serializable>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Serializable keyedRef;
            statement = connection.prepareStatement(selectRelationships);
            statement.setString(1, businessKey);
            statement.setString(2, relatedKey);
            statement.setString(3, relatedKey);
            statement.setString(4, businessKey);
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectRelationships + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t RELATED_BUSINESS_KEY=" + relatedKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                keyedRef = new KeyedReference();
                ((KeyedReference)keyedRef).setKeyName(resultSet.getString(2));
                ((KeyedReference)keyedRef).setKeyValue(resultSet.getString(3));
                ((KeyedReference)keyedRef).setTModelKey(resultSet.getString(1));
                refList.addElement(keyedRef);
            }
            keyedRef = refList;
            return keyedRef;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    private static void appendIn(StringBuffer sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("(");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("'").append(key).append("'");
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO PUBLISHER_ASSERTION (");
        sql.append("FROM_KEY,");
        sql.append("TO_KEY,");
        sql.append("TMODEL_KEY,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE,");
        sql.append("FROM_CHECK,");
        sql.append("TO_CHECK) ");
        sql.append("VALUES (?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("FROM_KEY,");
        sql.append("TO_KEY,");
        sql.append("TMODEL_KEY,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE ");
        sql.append("FROM PUBLISHER_ASSERTION ");
        sql.append("WHERE FROM_KEY=? ");
        sql.append("AND TO_KEY=? ");
        sql.append("AND TMODEL_KEY=? ");
        sql.append("AND KEY_NAME=? ");
        sql.append("AND KEY_VALUE=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("DELETE FROM PUBLISHER_ASSERTION ");
        sql.append("WHERE FROM_CHECK='false' ");
        sql.append("AND TO_CHECK='false'");
        deleteDeadAssertionsSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE PUBLISHER_ASSERTION ");
        sql.append("SET FROM_CHECK=? ");
        sql.append("WHERE FROM_KEY=? ");
        sql.append("AND TO_KEY=? ");
        sql.append("AND TMODEL_KEY=? ");
        sql.append("AND KEY_NAME=? ");
        sql.append("AND KEY_VALUE=?");
        updateFromCheckSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE PUBLISHER_ASSERTION ");
        sql.append("SET TO_CHECK=? ");
        sql.append("WHERE FROM_KEY=? ");
        sql.append("AND TO_KEY=? ");
        sql.append("AND TMODEL_KEY=? ");
        sql.append("AND KEY_NAME=? ");
        sql.append("AND KEY_VALUE=?");
        updateToCheckSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE PUBLISHER_ASSERTION ");
        sql.append("SET FROM_CHECK=? ");
        sql.append("WHERE FROM_KEY IN ");
        updateFromCheckByFromKeySQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE PUBLISHER_ASSERTION ");
        sql.append("SET TO_CHECK=? ");
        sql.append("WHERE TO_KEY IN ");
        updateFromCheckByFromKeySQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("FROM_KEY,");
        sql.append("TO_KEY,");
        sql.append("TMODEL_KEY,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE,");
        sql.append("FROM_CHECK,");
        sql.append("TO_CHECK ");
        sql.append("FROM PUBLISHER_ASSERTION ");
        selectAssertionsSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT TMODEL_KEY,KEY_NAME,KEY_VALUE ");
        sql.append("FROM PUBLISHER_ASSERTION ");
        sql.append("WHERE ((FROM_KEY = ? AND TO_KEY = ?) OR (FROM_KEY = ? AND TO_KEY = ?)) ");
        sql.append("AND FROM_CHECK = 'true' ");
        sql.append("AND TO_CHECK = 'true' ");
        selectRelationships = sql.toString();
    }
}

