/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindServiceByBusinessKeyQuery {
    private static Log log = LogFactory.getLog((Class)FindServiceByBusinessKeyQuery.class);
    static String selectSQL;

    FindServiceByBusinessKeyQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindServiceByBusinessKeyQuery.appendWhere(sql, businessKey);
        FindServiceByBusinessKeyQuery.appendIn(sql, keysIn);
        FindServiceByBusinessKeyQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the FindBusinessService ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the FindBusinessService Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, String businessKey) {
        sql.append("WHERE S.BUSINESS_KEY = ? ");
        sql.addValue(businessKey);
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND S.SERVICE_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("S.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("S.LAST_UPDATE ASC");
        } else {
            sql.append("S.LAST_UPDATE DESC");
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT S.SERVICE_KEY,S.LAST_UPDATE ");
        sql.append("FROM BUSINESS_SERVICE S ");
        selectSQL = sql.toString();
    }
}

