/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.service.BusinessService;

class BusinessServiceTable {
    private static Log log = LogFactory.getLog((Class)BusinessServiceTable.class);
    static String insertSQL = null;
    static String deleteSQL = null;
    static String selectSQL = null;
    static String selectByBusinessKeySQL = null;
    static String deleteByBusinessKeySQL = null;
    static String verifyOwnershipSQL = null;

    BusinessServiceTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(BusinessService service, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, service.getBusinessKey().toString());
            statement.setString(2, service.getServiceKey().toString());
            statement.setTimestamp(3, timeStamp);
            log.debug((Object)("insert into BUSINESS_SERVICE table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + service.getBusinessKey().toString() + "\n\t SERVICE_KEY=" + service.getServiceKey().toString() + "\n\t LAST_UPDATE=" + timeStamp.getTime() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("delete from BUSINESS_SERVICE table:\n\n\t" + deleteSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessService select(String serviceKey, Connection connection) throws SQLException {
        BusinessService service = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("select from BUSINESS_SERVICE table:\n\n\t" + selectSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                service = new BusinessService();
                service.setBusinessKey(resultSet.getString(1));
                service.setServiceKey(serviceKey);
            }
            BusinessService businessService = service;
            return businessService;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByBusinessKey(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteByBusinessKeySQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delet from the BUSINESS_SERVICE table:\n\n\t" + deleteByBusinessKeySQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectByBusinessKey(String businessKey, Connection connection) throws SQLException {
        Vector<BusinessService> serviceList = new Vector<BusinessService>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectByBusinessKeySQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("select from BUSINESS_SERVICE table:\n\n\t" + selectByBusinessKeySQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                BusinessService service = new BusinessService();
                service.setBusinessKey(businessKey);
                service.setServiceKey(resultSet.getString(1));
                serviceList.add(service);
            }
            Vector<BusinessService> vector = serviceList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyOwnership(String serviceKey, String publisherID, Connection connection) throws SQLException {
        if (serviceKey == null || publisherID == null) {
            return false;
        }
        boolean authorized = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(verifyOwnershipSQL);
            statement.setString(1, serviceKey);
            statement.setString(2, publisherID);
            log.debug((Object)("checking ownership of BUSINESS_SERVICE:\n\n\t" + verifyOwnershipSQL + "\n\t SERVICE_KEY=" + serviceKey + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                authorized = true;
            }
            boolean bl = authorized;
            return bl;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(100);
        sql.append("INSERT INTO BUSINESS_SERVICE (");
        sql.append("BUSINESS_KEY,");
        sql.append("SERVICE_KEY,");
        sql.append("LAST_UPDATE) ");
        sql.append("VALUES (?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BUSINESS_SERVICE ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("SELECT ");
        sql.append("BUSINESS_KEY ");
        sql.append("FROM BUSINESS_SERVICE ");
        sql.append("WHERE SERVICE_KEY=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("SERVICE_KEY ");
        sql.append("FROM BUSINESS_SERVICE ");
        sql.append("WHERE BUSINESS_KEY=?");
        selectByBusinessKeySQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BUSINESS_SERVICE ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteByBusinessKeySQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("* ");
        sql.append("FROM BUSINESS_ENTITY e, BUSINESS_SERVICE s ");
        sql.append("WHERE e.BUSINESS_KEY = s.BUSINESS_KEY ");
        sql.append("AND s.SERVICE_KEY=? ");
        sql.append("AND e.PUBLISHER_ID=?");
        verifyOwnershipSQL = sql.toString();
    }
}

