/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.KeyedReference;

class BusinessCategoryTable {
    private static Log log = LogFactory.getLog((Class)BusinessCategoryTable.class);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;

    BusinessCategoryTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, Vector keyRefs, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            int listSize = keyRefs.size();
            for (int categoryID = 0; categoryID < listSize; ++categoryID) {
                KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(categoryID);
                String tModelKeyValue = null;
                if (keyRef.getTModelKey() != null) {
                    tModelKeyValue = keyRef.getTModelKey().toString();
                }
                statement.setInt(2, categoryID);
                statement.setString(3, tModelKeyValue);
                statement.setString(4, keyRef.getKeyName());
                statement.setString(5, keyRef.getKeyValue());
                log.debug((Object)("insert into BUSINESS_CATEGORY table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CATEGORY_ID=" + categoryID + "\n\t TMODEL_KEY_REF=" + tModelKeyValue + "\n\t KEY_NAME=" + keyRef.getKeyName() + "\n\t KEY_VALUE=" + keyRef.getKeyValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Connection connection) throws SQLException {
        Vector<KeyedReference> keyRefList = new Vector<KeyedReference>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("select from BUSINESS_CATEGORY table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            KeyedReference keyRef = null;
            while (resultSet.next()) {
                keyRef = new KeyedReference();
                keyRef.setTModelKey(resultSet.getString(1));
                keyRef.setKeyName(resultSet.getString(2));
                keyRef.setKeyValue(resultSet.getString(3));
                keyRefList.add(keyRef);
                keyRef = null;
            }
            Vector<KeyedReference> vector = keyRefList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from BUSINESS_CATEGORY table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO BUSINESS_CATEGORY (");
        sql.append("BUSINESS_KEY,");
        sql.append("CATEGORY_ID,");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("CATEGORY_ID ");
        sql.append("FROM BUSINESS_CATEGORY ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("ORDER BY CATEGORY_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BUSINESS_CATEGORY ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

