/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.event;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventEmitter;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.logging.Logger;
import org.jboss.util.CollectionsFactory;

public class AbstractEventEmitter
implements KernelEventEmitter {
    private static final Logger log = Logger.getLogger((Class)AbstractEventEmitter.class);
    protected static final Object NULL = new Object();
    protected Map eventListenerRegistry = CollectionsFactory.createConcurrentReaderMap();
    private long emitterSequence = 0L;

    public boolean hasListeners() {
        return !this.eventListenerRegistry.isEmpty();
    }

    public KernelEvent createEvent(String string, Object object) {
        return new AbstractEvent(this, string, this.nextEmitterSequence(), System.currentTimeMillis(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(KernelEventListener kernelEventListener, KernelEventFilter kernelEventFilter, Object object) throws Throwable {
        Object object2 = kernelEventFilter == null ? NULL : kernelEventFilter;
        Object object3 = object == null ? NULL : object;
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            List list;
            Map map2 = (Map)this.eventListenerRegistry.get(object2);
            if (map2 == null) {
                map2 = CollectionsFactory.createConcurrentReaderMap();
                this.eventListenerRegistry.put(object2, map2);
            }
            if ((list = (List)map2.get(object3)) == null) {
                list = CollectionsFactory.createCopyOnWriteList();
                map2.put(object3, list);
            }
            list.add(kernelEventListener);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registered listener: " + kernelEventListener + " with filter=" + kernelEventFilter + " handback=" + object + " on object " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(KernelEventListener kernelEventListener, KernelEventFilter kernelEventFilter, Object object) throws Throwable {
        Object object2 = kernelEventFilter == null ? NULL : kernelEventFilter;
        Object object3 = object == null ? NULL : object;
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            List list;
            Map map2 = (Map)this.eventListenerRegistry.get(object2);
            if (map2 != null && (list = (List)map2.get(object3)) != null && list.remove(kernelEventListener)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unregistered listener: " + kernelEventListener + " with filter=" + kernelEventFilter + " handback=" + object + " on object " + this));
                }
                return;
            }
        }
        throw new IllegalStateException("Listener not registered.");
    }

    public void fireKernelEvent(KernelEvent kernelEvent) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Firing event: " + kernelEvent + " on object " + this));
        }
        if (!this.eventListenerRegistry.isEmpty()) {
            Iterator iterator = this.eventListenerRegistry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                KernelEventFilter kernelEventFilter = null;
                Object k = entry.getKey();
                if (k != NULL) {
                    kernelEventFilter = (KernelEventFilter)k;
                }
                Map map = (Map)entry.getValue();
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    Object k2 = entry2.getKey();
                    if (k2 == NULL) {
                        k2 = null;
                    }
                    List list = (List)entry2.getValue();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        KernelEventListener kernelEventListener = (KernelEventListener)listIterator.next();
                        try {
                            if (kernelEventFilter != null && !kernelEventFilter.wantEvent(kernelEvent, k2)) continue;
                            this.fireKernelEvent(kernelEventListener, kernelEvent, k2);
                        }
                        catch (Throwable throwable) {
                            log.debug((Object)"Ignored unhandled throwable: ", throwable);
                        }
                    }
                }
            }
        }
    }

    protected void fireKernelEvent(KernelEventListener kernelEventListener, KernelEvent kernelEvent, Object object) {
        kernelEventListener.onEvent(kernelEvent, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextEmitterSequence() {
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            return this.emitterSequence++;
        }
    }
}

