/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.config.property;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.plugins.bootstrap.basic.KernelConstants;
import org.jboss.kernel.plugins.config.AbstractKernelConfig;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.bootstrap.KernelInitializer;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;

public class PropertyKernelConfig
extends AbstractKernelConfig {
    protected Properties properties;

    public PropertyKernelConfig(Properties properties) throws Exception {
        this.properties = properties;
        this.initializeProperties();
    }

    protected void initializeProperties() {
        if (!this.properties.isEmpty() && this.log.isTraceEnabled()) {
            this.log.trace((Object)"Dumping properties");
            TreeSet<Object> treeSet = new TreeSet<Object>(this.properties.keySet());
            Iterator<Object> iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.log.trace((Object)(string + "=" + this.properties.get(string)));
            }
        }
    }

    public KernelBus createKernelBus() throws Throwable {
        return (KernelBus)this.getImplementation(KernelConstants.KERNEL_BUS_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelBus");
    }

    public KernelConfigurator createKernelConfigurator() throws Throwable {
        return (KernelConfigurator)this.getImplementation(KernelConstants.KERNEL_CONFIGURATOR_PROPERTY, "org.jboss.kernel.plugins.config.AbstractKernelConfigurator");
    }

    public KernelController createKernelController() throws Throwable {
        return (KernelController)this.getImplementation(KernelConstants.KERNEL_CONTROLLER_PROPERTY, "org.jboss.kernel.plugins.dependency.AbstractKernelController");
    }

    public KernelEventManager createKernelEventManager() throws Throwable {
        return (KernelEventManager)this.getImplementation(KernelConstants.KERNEL_EVENT_MANAGER_PROPERTY, "org.jboss.kernel.plugins.event.AbstractEventManager");
    }

    public KernelInitializer createKernelInitializer() throws Throwable {
        return (KernelInitializer)this.getImplementation(KernelConstants.KERNEL_INITIALIZER_PROPERTY, "org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer");
    }

    public KernelRegistry createKernelRegistry() throws Throwable {
        return (KernelRegistry)this.getImplementation(KernelConstants.KERNEL_REGISTRY_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelRegistry");
    }

    protected Object getImplementation(String string, String string2) throws Throwable {
        String string3 = this.properties.getProperty(string, string2);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(string + " using implementation " + string3));
        }
        BeanInfo beanInfo = this.getBeanInfo(string3, this.getClass().getClassLoader());
        BeanMetaData beanMetaData = this.getBeanMetaData(beanInfo, string3);
        return Configurator.instantiateAndConfigure(this, beanInfo, beanMetaData);
    }

    protected BeanMetaData getBeanMetaData(BeanInfo beanInfo, String string) throws Exception {
        return null;
    }
}

