/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.info.plugins.AbstractBeanInfo;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.collection.WeakValueHashMap;

public class AbstractBeanInfoFactory
implements BeanInfoFactory {
    protected Map cache = new WeakHashMap();

    protected static boolean isGetter(MethodInfo methodInfo) {
        String string = methodInfo.getName();
        TypeInfo typeInfo = methodInfo.getReturnType();
        TypeInfo[] typeInfoArray = methodInfo.getParameterTypes();
        return (string.length() > 3 && string.startsWith("get") || string.length() > 2 && string.startsWith("is")) && typeInfoArray.length == 0 && !PrimitiveInfo.VOID.equals((Object)typeInfo);
    }

    protected static boolean isSetter(MethodInfo methodInfo) {
        String string = methodInfo.getName();
        TypeInfo typeInfo = methodInfo.getReturnType();
        TypeInfo[] typeInfoArray = methodInfo.getParameterTypes();
        return string.length() > 3 && string.startsWith("set") && typeInfoArray.length == 1 && PrimitiveInfo.VOID.equals((Object)typeInfo);
    }

    protected static String getUpperPropertyName(String string) {
        int n = 3;
        if (string.startsWith("is")) {
            n = 2;
        }
        return string.substring(n);
    }

    protected static String getLowerPropertyName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(Character.toLowerCase(string.charAt(0)));
        if (string.length() > 1) {
            stringBuffer.append(string.substring(1));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanInfo getBeanInfo(ClassLoader classLoader, ClassAdapter classAdapter) {
        Map map = this.cache;
        synchronized (map) {
            Object object;
            ClassInfo classInfo = classAdapter.getClassInfo();
            String string = classInfo.getName();
            Map map2 = (Map)this.cache.get(classLoader);
            if (map2 != null && (object = (BeanInfo)map2.get(string)) != null) {
                return object;
            }
            if (classInfo.isInterface()) {
                throw new IllegalArgumentException(classInfo.getName() + " is an interface");
            }
            object = this.getConstructors(classInfo);
            Set set = this.getMethods(classInfo);
            Set set2 = this.getProperties(set);
            Set set3 = this.getEvents(classInfo);
            BeanInfo beanInfo = this.createBeanInfo(classAdapter, set2, (Set)object, set, set3);
            if (map2 == null) {
                map2 = new WeakValueHashMap();
                this.cache.put(classLoader, map2);
            }
            map2.put(string, beanInfo);
            return beanInfo;
        }
    }

    protected BeanInfo createBeanInfo(ClassAdapter classAdapter, Set set, Set set2, Set set3, Set set4) {
        return new AbstractBeanInfo(this, classAdapter, set, set2, set3, set4);
    }

    protected Set getConstructors(ClassInfo classInfo) {
        ConstructorInfo[] constructorInfoArray = classInfo.getDeclaredConstructors();
        if (constructorInfoArray == null || constructorInfoArray.length == 0) {
            return null;
        }
        HashSet<ConstructorInfo> hashSet = new HashSet<ConstructorInfo>();
        for (int i = 0; i < constructorInfoArray.length; ++i) {
            hashSet.add(constructorInfoArray[i]);
        }
        return hashSet;
    }

    protected Set getMethods(ClassInfo classInfo) {
        HashSet<MethodInfo> hashSet = new HashSet<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methodInfoArray = classInfo.getDeclaredMethods();
            if (methodInfoArray != null && methodInfoArray.length > 0) {
                for (int i = 0; i < methodInfoArray.length; ++i) {
                    if (hashSet.contains(methodInfoArray[i])) continue;
                    hashSet.add(methodInfoArray[i]);
                }
            }
            classInfo = classInfo.getSuperclass();
        }
        return hashSet;
    }

    protected Set getProperties(Set set) {
        String string;
        ArrayList arrayList;
        MethodInfo methodInfo;
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (!set.isEmpty()) {
            object4 = set.iterator();
            while (object4.hasNext()) {
                object3 = (MethodInfo)object4.next();
                if (!object3.isPublic() || object3.isStatic()) continue;
                object2 = object3.getName();
                string2 = AbstractBeanInfoFactory.getUpperPropertyName((String)object2);
                if (AbstractBeanInfoFactory.isGetter((MethodInfo)object3)) {
                    hashMap.put(string2, object3);
                    continue;
                }
                if (!AbstractBeanInfoFactory.isSetter((MethodInfo)object3)) continue;
                object = (ArrayList)hashMap2.get(string2);
                if (object == null) {
                    object = new ArrayList();
                    hashMap2.put(string2, object);
                }
                ((ArrayList)object).add(object3);
            }
        }
        object4 = new HashSet();
        if (!hashMap.isEmpty()) {
            object3 = hashMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                string2 = (String)object2.getKey();
                object = (MethodInfo)object2.getValue();
                methodInfo = null;
                arrayList = (ArrayList)hashMap2.remove(string2);
                if (arrayList != null && arrayList.size() != 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        MethodInfo methodInfo2 = (MethodInfo)arrayList.get(i);
                        TypeInfo typeInfo = methodInfo2.getParameterTypes()[0];
                        if (!object.getReturnType().equals(typeInfo)) continue;
                        methodInfo = methodInfo2;
                        break;
                    }
                }
                string = AbstractBeanInfoFactory.getLowerPropertyName(string2);
                ((HashSet)object4).add(new AbstractPropertyInfo(string, string2, object.getReturnType(), (MethodInfo)object, methodInfo));
            }
        }
        if (!hashMap2.isEmpty()) {
            object3 = hashMap2.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                string2 = (String)object2.getKey();
                object = (ArrayList)object2.getValue();
                if (((ArrayList)object).size() != 1) continue;
                methodInfo = (MethodInfo)((ArrayList)object).get(0);
                arrayList = methodInfo.getParameterTypes()[0];
                string = AbstractBeanInfoFactory.getLowerPropertyName(string2);
                ((HashSet)object4).add(new AbstractPropertyInfo(string, string2, (TypeInfo)arrayList, null, methodInfo));
            }
        }
        return object4;
    }

    protected Set getEvents(ClassInfo classInfo) {
        return null;
    }
}

