/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.servletunit.ServletUnitOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class ServletUnitHttpResponse
implements HttpServletResponse {
    private String _contentType = "text/plain";
    private String _encoding = "us-ascii";
    private PrintWriter _writer;
    private ServletOutputStream _servletStream;
    private ByteArrayOutputStream _outputStream;
    private int _status = 200;
    private String _statusMessage = "OK";
    private Hashtable _headers = new Hashtable();
    private boolean _headersComplete;
    private Vector _cookies = new Vector();

    ServletUnitHttpResponse() {
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void addCookie(Cookie cookie) {
        this._cookies.addElement(cookie);
    }

    public boolean containsHeader(String name) {
        throw new RuntimeException("containsHeader not implemented");
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(301);
        this.setHeader("Location", location);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "");
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc);
        this._statusMessage = msg;
        this._writer = null;
        this._servletStream = null;
        this.setContentType("text/html");
        this.getWriter().println("<html><head><title>" + msg + "</title></head><body>" + msg + "</body></html>");
    }

    public void setStatus(int sc) {
        this._status = sc;
    }

    public void setStatus(int sc, String msg) {
        this.setStatus(sc);
    }

    public void setHeader(String name, String value) {
        this._headers.put(name.toUpperCase(), value);
    }

    public void setIntHeader(String name, int value) {
        throw new RuntimeException("setIntHeader not implemented");
    }

    public void setDateHeader(String name, long date) {
        throw new RuntimeException("setDateHeader not implemented");
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public void setContentType(String type) {
        String[] typeAndEncoding = HttpUnitUtils.parseContentTypeHeader(type);
        this._contentType = typeAndEncoding[0];
        if (typeAndEncoding[1] != null) {
            this._encoding = typeAndEncoding[1];
        }
        this.setHeader("Content-type", this._contentType + "; charset=" + this._encoding);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._writer != null) {
            throw new IllegalStateException("Tried to create output stream; writer already exists");
        }
        if (this._servletStream == null) {
            this._outputStream = new ByteArrayOutputStream();
            this._servletStream = new ServletUnitOutputStream(this._outputStream);
        }
        return this._servletStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this._servletStream != null) {
            throw new IllegalStateException("Tried to create writer; output stream already exists");
        }
        if (this._writer == null) {
            this._outputStream = new ByteArrayOutputStream();
            this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)this._outputStream, this.getCharacterEncoding()));
        }
        return this._writer;
    }

    public void setContentLength(int len) {
        throw new RuntimeException("setContentLength not implemented");
    }

    public void addHeader(String name, String value) {
        throw new RuntimeException("addHeader not implemented");
    }

    public void addIntHeader(String name, int value) {
        throw new RuntimeException("addIntHeader not implemented");
    }

    public void addDateHeader(String name, long value) {
        throw new RuntimeException("addDateHeader not implemented");
    }

    public void setBufferSize(int size) {
        throw new RuntimeException("setBufferSize not implemented");
    }

    public int getBufferSize() {
        return 0;
    }

    public boolean isCommitted() {
        return false;
    }

    public void flushBuffer() throws IOException {
        throw new RuntimeException("flushBuffer not implemented");
    }

    public void reset() {
        throw new RuntimeException("reset not implemented");
    }

    public void setLocale(Locale locale) {
        throw new RuntimeException("setLocale not implemented");
    }

    public Locale getLocale() {
        throw new RuntimeException("getLocale not implemented");
    }

    public void resetBuffer() {
    }

    void restartResponse() {
        this._headers = new Hashtable();
        this._headersComplete = false;
        this._outputStream = null;
        this._servletStream = null;
        this._status = 200;
        this._writer = null;
    }

    String getContentType() {
        return this._contentType;
    }

    byte[] getContents() {
        if (this._outputStream == null) {
            return new byte[0];
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        return this._outputStream.toByteArray();
    }

    int getStatus() {
        return this._status;
    }

    String getMessage() {
        return this._statusMessage;
    }

    public String[] getHeaderFieldNames() {
        if (!this._headersComplete) {
            this.completeHeaders();
        }
        Vector names = new Vector();
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    String getHeaderField(String name) {
        if (!this._headersComplete) {
            this.completeHeaders();
        }
        return (String)this._headers.get(name.toUpperCase());
    }

    private void completeHeaders() {
        if (this._headersComplete) {
            return;
        }
        this.addCookieHeader();
        this._headersComplete = true;
    }

    private void addCookieHeader() {
        if (this._cookies.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration e = this._cookies.elements();
        while (e.hasMoreElements()) {
            Cookie cookie = (Cookie)e.nextElement();
            sb.append(cookie.getName()).append('=').append(cookie.getValue());
            if (!e.hasMoreElements()) continue;
            sb.append(',');
        }
        this.setHeader("Set-Cookie", sb.toString());
    }
}

