/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.xml.ws.resources.HttpserverMessages;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.server.ServerConnectionImpl;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

final class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private final HttpAdapter adapter;
    private final Executor executor;

    public WSHttpHandler(@NotNull HttpAdapter adapter, @Nullable Executor executor) {
        assert (adapter != null);
        this.adapter = adapter;
        this.executor = executor;
    }

    public void handle(HttpExchange msg) {
        try {
            logger.fine("Received HTTP request:" + msg.getRequestURI());
            if (this.executor != null) {
                this.executor.execute(new HttpHandlerRunnable(msg));
            } else {
                this.handleExchange(msg);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExchange(HttpExchange msg) throws IOException {
        ServerConnectionImpl con = new ServerConnectionImpl(this.adapter, msg);
        try {
            logger.fine("Received HTTP request:" + msg.getRequestURI());
            String method = msg.getRequestMethod();
            if (method.equals(GET_METHOD)) {
                String queryString = msg.getRequestURI().getQuery();
                logger.fine("Query String for request =" + queryString);
                if (this.adapter.isMetadataQuery(queryString)) {
                    this.adapter.publishWSDL(con, WSHttpHandler.getRequestAddress(msg), msg.getRequestURI().getQuery());
                } else {
                    this.adapter.handle(con);
                }
            } else if (method.equals(POST_METHOD) || method.equals(HEAD_METHOD) || method.equals(PUT_METHOD) || method.equals(DELETE_METHOD)) {
                this.adapter.handle(con);
            } else {
                logger.warning(HttpserverMessages.UNEXPECTED_HTTP_METHOD(method));
            }
        }
        finally {
            msg.close();
        }
    }

    @NotNull
    static String getRequestAddress(HttpExchange msg) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(msg instanceof HttpsExchange ? "https" : "http");
        strBuf.append("://");
        Object hostHeader = msg.getRequestHeaders().get("Host");
        if (hostHeader != null) {
            strBuf.append((String)hostHeader.get(0));
        } else {
            strBuf.append(msg.getLocalAddress().getHostName());
            strBuf.append(":");
            strBuf.append(msg.getLocalAddress().getPort());
        }
        strBuf.append(msg.getRequestURI().getPath());
        return strBuf.toString();
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange msg) {
            this.msg = msg;
        }

        public void run() {
            try {
                WSHttpHandler.this.handleExchange(this.msg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

