/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.wsdl;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartImpl;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLBoundOperationImpl
extends AbstractExtensibleImpl
implements WSDLBoundOperation {
    private final QName name;
    private final Map<String, ParameterBinding> inputParts;
    private final Map<String, ParameterBinding> outputParts;
    private final Map<String, ParameterBinding> faultParts;
    private final Map<String, String> inputMimeTypes;
    private final Map<String, String> outputMimeTypes;
    private final Map<String, String> faultMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private boolean explicitFaultSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Boolean emptyFaultBody;
    private final Map<String, WSDLPartImpl> inParts;
    private final Map<String, WSDLPartImpl> outParts;
    private final Map<String, WSDLPartImpl> fltParts;
    private WSDLOperationImpl operation;
    private String soapAction;
    private WSDLBoundOperation.ANONYMOUS anonymous;
    private final WSDLBoundPortTypeImpl owner;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private String reqNamespace;
    private String respNamespace;
    private QName payloadName;
    private boolean emptyPayload;
    private Map<QName, WSDLMessageImpl> messages;

    public WSDLBoundOperationImpl(XMLStreamReader xsr, WSDLBoundPortTypeImpl owner, QName name) {
        super(xsr);
        this.name = name;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.faultParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.faultMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, WSDLPartImpl>();
        this.outParts = new HashMap<String, WSDLPartImpl>();
        this.fltParts = new HashMap<String, WSDLPartImpl>();
        this.owner = owner;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction != null ? soapAction : "";
    }

    public WSDLPartImpl getPart(String partName, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            return this.inParts.get(partName);
        }
        if (mode == WebParam.Mode.OUT) {
            return this.outParts.get(partName);
        }
        return null;
    }

    public void addPart(WSDLPartImpl part, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            this.inParts.put(part.getName(), part);
        } else if (mode == WebParam.Mode.OUT) {
            this.outParts.put(part.getName(), part);
        }
    }

    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    public Map<String, ParameterBinding> getFaultParts() {
        return this.faultParts;
    }

    public Map<String, String> getInputMimeTypes() {
        return this.inputMimeTypes;
    }

    public Map<String, String> getOutputMimeTypes() {
        return this.outputMimeTypes;
    }

    public Map<String, String> getFaultMimeTypes() {
        return this.faultMimeTypes;
    }

    public ParameterBinding getInputBinding(String part) {
        ParameterBinding block;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.inputParts.get(part)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public ParameterBinding getOutputBinding(String part) {
        ParameterBinding block;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.outputParts.get(part)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public ParameterBinding getFaultBinding(String part) {
        ParameterBinding block;
        if (this.emptyFaultBody == null) {
            this.emptyFaultBody = this.faultParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.faultParts.get(part)) == null) {
            if (this.explicitFaultSOAPBodyParts || this.emptyFaultBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public String getMimeTypeForInputPart(String part) {
        return this.inputMimeTypes.get(part);
    }

    public String getMimeTypeForOutputPart(String part) {
        return this.outputMimeTypes.get(part);
    }

    public String getMimeTypeForFaultPart(String part) {
        return this.faultMimeTypes.get(part);
    }

    @Override
    public WSDLOperation getOperation() {
        return this.operation;
    }

    public void setInputExplicitBodyParts(boolean b) {
        this.explicitInputSOAPBodyParts = b;
    }

    public void setOutputExplicitBodyParts(boolean b) {
        this.explicitOutputSOAPBodyParts = b;
    }

    public void setFaultExplicitBodyParts(boolean b) {
        this.explicitFaultSOAPBodyParts = b;
    }

    public void setStyle(SOAPBinding.Style style) {
        this.style = style;
    }

    @Nullable
    public QName getPayloadName() {
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            return this.name;
        }
        if (this.emptyPayload) {
            return null;
        }
        if (this.payloadName != null) {
            return this.payloadName;
        }
        QName inMsgName = this.operation.getInput().getMessage().getName();
        WSDLMessageImpl message = this.messages.get(inMsgName);
        for (WSDLPartImpl part : message.parts()) {
            ParameterBinding binding = this.getInputBinding(part.getName());
            if (!binding.isBody()) continue;
            this.payloadName = part.getDescriptor().name();
            return this.payloadName;
        }
        this.emptyPayload = true;
        return null;
    }

    public String getRequestNamespace() {
        return this.reqNamespace;
    }

    public void setRequestNamespace(String ns) {
        this.reqNamespace = ns;
    }

    public String getResponseNamespace() {
        return this.respNamespace;
    }

    public void setResponseNamespace(String ns) {
        this.respNamespace = ns;
    }

    WSDLBoundPortTypeImpl getOwner() {
        return this.owner;
    }

    void freeze(WSDLModelImpl parent) {
        this.messages = parent.getMessages();
        this.operation = this.owner.getPortType().get(this.name.getLocalPart());
    }

    public void setAnonymous(WSDLBoundOperation.ANONYMOUS anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public WSDLBoundOperation.ANONYMOUS getAnonymous() {
        return this.anonymous;
    }
}

