/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.impl.ReferenceHolder;

public class OrderingGroup {
    private List<ReferenceHolder> sortedList = new LinkedList<ReferenceHolder>();
    private HashMap<Long, ReferenceHolder> refMap = new HashMap();
    private String groupName;
    private static final Logger log = Logger.getLogger(OrderingGroup.class);

    public OrderingGroup(String name) {
        this.groupName = name;
    }

    private OrderingGroup() {
    }

    public boolean register(MessageReference ref) {
        Long mid = ref.getMessage().getMessageID();
        ReferenceHolder holder = this.refMap.get(mid);
        if (holder != null) {
            return true;
        }
        try {
            holder = new ReferenceHolder(mid);
        }
        catch (JMSException e) {
            log.error((Object)"error creating ReferenceHolder. ", (Throwable)e);
        }
        if (holder == null) {
            return false;
        }
        this.sortedList.add(holder);
        this.refMap.put(mid, holder);
        return true;
    }

    public int isAvailable(MessageReference ref) {
        if (this.sortedList.size() == 0) {
            return 0;
        }
        ReferenceHolder holder = this.sortedList.get(0);
        return holder.isAvailable(ref);
    }

    public void unregister(MessageReference ref) {
        long count;
        if (this.sortedList.size() == 0) {
            return;
        }
        ReferenceHolder holder = this.sortedList.get(0);
        if (holder == null) {
            return;
        }
        if (holder.matchMessage(ref) && (count = holder.releaseRef()) == 0L) {
            this.sortedList.remove(0);
            this.refMap.remove(ref.getMessage().getMessageID());
        }
    }

    public boolean hasPendingMessage() {
        boolean result = false;
        if (this.sortedList.size() == 0) {
            return result;
        }
        result = this.sortedList.size() > 0;
        return result;
    }

    public void markSending(MessageReference ref) {
        if (this.sortedList.size() == 0) {
            return;
        }
        ReferenceHolder holder = this.sortedList.get(0);
        if (holder.matchMessage(ref)) {
            holder.markSending();
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void unmarkSending(MessageReference ref) {
        if (this.sortedList.size() == 0) {
            return;
        }
        ReferenceHolder holder = this.sortedList.get(0);
        if (holder.matchMessage(ref)) {
            holder.unmarkSending();
        }
    }
}

