/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.delegate.ClientBrowserDelegate;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.delegate.Ack;
import org.jboss.jms.delegate.BrowserDelegate;
import org.jboss.jms.delegate.Cancel;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.delegate.DeliveryRecovery;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.destination.JBossTopic;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.DestinationManager;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.jms.server.destination.ManagedTopic;
import org.jboss.jms.server.endpoint.ServerBrowserEndpoint;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerConsumerEndpoint;
import org.jboss.jms.server.endpoint.SessionInternalEndpoint;
import org.jboss.jms.server.endpoint.advised.BrowserAdvised;
import org.jboss.jms.server.endpoint.advised.ConsumerAdvised;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.selector.Selector;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.Channel;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.IDManager;
import org.jboss.messaging.core.impl.MessagingQueue;
import org.jboss.messaging.core.impl.SimpleDelivery;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.core.impl.tx.TransactionException;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.core.impl.tx.TxCallback;
import org.jboss.messaging.util.CompatibleExecutor;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.ExecutorFactory;
import org.jboss.messaging.util.GUIDGenerator;
import org.jboss.messaging.util.JBMThreadFactory;
import org.jboss.messaging.util.MessageQueueNameHelper;
import org.jboss.messaging.util.OrderedExecutorFactory;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class ServerSessionEndpoint
implements SessionInternalEndpoint {
    private static final Logger log = Logger.getLogger(ServerSessionEndpoint.class);
    static final String DUR_SUB_STATE_CONSUMERS = "C";
    static final String TEMP_QUEUE_MESSAGECOUNTER_PREFIX = "TempQueue.";
    private static final long DELIVERY_WAIT_TIMEOUT = 5000L;
    private static final long CLOSE_WAIT_TIMEOUT = 10000L;
    private static final ExecutorFactory executorFactory = new OrderedExecutorFactory(Executors.newCachedThreadPool(new JBMThreadFactory("server-session-endpoint")));
    private boolean trace = log.isTraceEnabled();
    private boolean debug = log.isDebugEnabled();
    private String id;
    private volatile boolean closed;
    private ServerConnectionEndpoint connectionEndpoint;
    private ServerInvokerCallbackHandler callbackHandler;
    private ServerPeer sp;
    private Map consumers;
    private Map browsers;
    private PersistenceManager pm;
    private MessageStore ms;
    private DestinationManager dm;
    private IDManager idm;
    private TransactionRepository tr;
    private PostOffice postOffice;
    private int nodeId;
    private int defaultMaxDeliveryAttempts;
    private long defaultRedeliveryDelay;
    private Queue defaultDLQ;
    private Queue defaultExpiryQueue;
    private boolean supportsFailover;
    private boolean replicating;
    private Object deliveryLock = new Object();
    private Map deliveries;
    private long deliveryIdSequence;
    CompatibleExecutor executor;
    private LinkedQueue toDeliver = new LinkedQueue();
    private boolean waitingToClose = false;
    private Object waitLock = new Object();
    private long lastSequence = -1L;
    private Map<Long, Long> failureCanceledDels;
    private AtomicBoolean isSuckerSession = new AtomicBoolean(false);

    ServerSessionEndpoint(String sessionID, ServerConnectionEndpoint connectionEndpoint, boolean replicating) throws Exception {
        this.id = sessionID;
        this.executor = executorFactory.getExecutor("jbm-server-session-" + sessionID);
        this.connectionEndpoint = connectionEndpoint;
        this.replicating = replicating;
        this.callbackHandler = connectionEndpoint.getCallbackHandler();
        this.sp = connectionEndpoint.getServerPeer();
        this.pm = this.sp.getPersistenceManagerInstance();
        this.ms = this.sp.getMessageStore();
        this.dm = this.sp.getDestinationManager();
        this.postOffice = this.sp.getPostOfficeInstance();
        this.supportsFailover = connectionEndpoint.getConnectionFactoryEndpoint().isSupportsFailover() && this.postOffice.isClustered();
        this.idm = this.sp.getChannelIDManager();
        this.nodeId = this.sp.getServerPeerID();
        this.tr = this.sp.getTxRepository();
        this.consumers = new HashMap();
        this.browsers = new HashMap();
        this.defaultDLQ = this.sp.getDefaultDLQInstance();
        this.defaultExpiryQueue = this.sp.getDefaultExpiryQueueInstance();
        this.tr = this.sp.getTxRepository();
        this.defaultMaxDeliveryAttempts = this.sp.getDefaultMaxDeliveryAttempts();
        this.defaultRedeliveryDelay = this.sp.getDefaultRedeliveryDelay();
        this.deliveries = new ConcurrentHashMap();
        this.failureCanceledDels = new HashMap<Long, Long>();
    }

    public ConsumerDelegate createConsumerDelegate(JBossDestination jmsDestination, String selector, boolean noLocal, String subscriptionName, boolean isCC, boolean autoFlowControl) throws JMSException {
        try {
            if (jmsDestination.isDirect()) {
                return this.createConsumerDelegateDirect(jmsDestination.getName(), selector);
            }
            return this.createConsumerDelegateInternal(jmsDestination, selector, noLocal, subscriptionName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createConsumerDelegate");
        }
    }

    public BrowserDelegate createBrowserDelegate(JBossDestination jmsDestination, String selector) throws JMSException {
        try {
            return this.createBrowserDelegateInternal(jmsDestination, selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createBrowserDelegate");
        }
    }

    public JBossQueue createQueue(String name) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
            ManagedDestination dest = this.dm.getDestination(name, true);
            if (dest == null) {
                throw new JMSException("There is no administratively defined queue with name:" + name);
            }
            return new JBossQueue(dest.getName());
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createQueue");
        }
    }

    public JBossTopic createTopic(String name) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
            ManagedDestination dest = this.dm.getDestination(name, false);
            if (dest == null) {
                throw new JMSException("There is no administratively defined topic with name:" + name);
            }
            return new JBossTopic(name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createTopic");
        }
    }

    public void close() throws JMSException {
        try {
            this.localClose();
            this.connectionEndpoint.removeSession(this.id);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long closing(long sequence) throws JMSException {
        if (this.trace) {
            log.trace((Object)(this + " closing"));
        }
        if (sequence != -1L) {
            Object object = this.waitLock;
            synchronized (object) {
                long wait;
                long start;
                for (wait = 10000L; this.lastSequence != sequence - 1L && wait > 0L; wait -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    try {
                        this.waitLock.wait(wait);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (wait <= 0L) {
                    log.warn((Object)"Timed out waiting for last message");
                }
            }
        }
        return -1L;
    }

    public void send(JBossMessage message, boolean checkForDuplicates) throws JMSException {
        throw new IllegalStateException("Should not be handled here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JBossMessage message, boolean checkForDuplicates, long sequence) throws JMSException {
        block6: {
            try {
                if (checkForDuplicates && !message.isReliable()) {
                    return;
                }
                this.connectionEndpoint.sendMessage(message, null, checkForDuplicates);
                if (sequence == -1L) break block6;
                Object object = this.waitLock;
                synchronized (object) {
                    this.lastSequence = sequence;
                    this.waitLock.notifyAll();
                }
            }
            catch (Throwable t) {
                throw ExceptionUtil.handleJMSInvocation(t, this + " send");
            }
        }
    }

    public boolean acknowledgeDelivery(Ack ack) throws JMSException {
        try {
            return this.acknowledgeDeliveryInternal(ack);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " acknowledgeDelivery");
        }
    }

    public void acknowledgeDeliveries(List acks) throws JMSException {
        if (this.trace) {
            log.trace((Object)(this + " acknowledges deliveries " + acks));
        }
        try {
            for (Ack ack : acks) {
                this.acknowledgeDeliveryInternal(ack);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " acknowledgeDeliveries");
        }
    }

    public void cancelDelivery(Cancel cancel) throws JMSException {
        if (this.trace) {
            log.trace((Object)(this + " cancelDelivery " + cancel));
        }
        try {
            Delivery del = this.cancelDeliveryInternal(cancel);
            if (del != null) {
                this.promptDelivery((Channel)del.getObserver());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " cancelDelivery");
        }
    }

    public void cancelDeliveries(List cancels) throws JMSException {
        if (this.trace) {
            log.trace((Object)(this + " cancels deliveries " + cancels));
        }
        try {
            HashSet<DeliveryObserver> channels = new HashSet<DeliveryObserver>();
            for (int i = cancels.size() - 1; i >= 0; --i) {
                Delivery del;
                Cancel cancel = (Cancel)cancels.get(i);
                if (this.trace) {
                    log.trace((Object)(this + " cancelling delivery " + cancel.getDeliveryId()));
                }
                if ((del = this.cancelDeliveryInternal(cancel)) == null) continue;
                channels.add(del.getObserver());
            }
            if (this.trace) {
                log.trace((Object)"Cancelled deliveries");
            }
            this.promptDelivery(channels);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " cancelDeliveries");
        }
    }

    public void recoverDeliveries(List deliveryRecoveryInfos, String oldSessionID) throws JMSException {
        if (this.trace) {
            log.trace((Object)(this + " recovers deliveries " + deliveryRecoveryInfos));
        }
        try {
            String queueName;
            if (!this.postOffice.isClustered()) {
                throw new IllegalStateException("Recovering deliveries but post office is not clustered!");
            }
            long maxDeliveryId = 0L;
            HashMap<String, ArrayList<DeliveryRecovery>> ackMap = new HashMap<String, ArrayList<DeliveryRecovery>>();
            for (DeliveryRecovery deliveryRecovery : deliveryRecoveryInfos) {
                queueName = deliveryRecovery.getQueueName();
                ArrayList<DeliveryRecovery> acks = (ArrayList<DeliveryRecovery>)ackMap.get(queueName);
                if (acks == null) {
                    acks = new ArrayList<DeliveryRecovery>();
                    ackMap.put(queueName, acks);
                }
                acks.add(deliveryRecovery);
            }
            for (Map.Entry entry : ackMap.entrySet()) {
                queueName = (String)entry.getKey();
                Binding binding = this.postOffice.getBindingForQueueName(queueName);
                Queue queue = binding.queue;
                if (queue == null) {
                    throw new IllegalStateException("Cannot find queue with queue name: " + queueName);
                }
                List acks = (List)entry.getValue();
                ArrayList<Long> ids = new ArrayList<Long>(acks.size());
                for (DeliveryRecovery info : acks) {
                    ids.add(new Long(info.getMessageID()));
                }
                JMSCondition cond = (JMSCondition)binding.condition;
                ManagedDestination dest = this.sp.getDestinationManager().getDestination(cond.getName(), cond.isQueue());
                if (dest == null) {
                    throw new IllegalStateException("Cannot find managed destination with name " + cond.getName() + " isQueue" + cond.isQueue());
                }
                Queue dlqToUse = dest.getDLQ() == null ? this.defaultDLQ : dest.getDLQ();
                Queue expiryQueueToUse = dest.getExpiryQueue() == null ? this.defaultExpiryQueue : dest.getExpiryQueue();
                int maxDeliveryAttemptsToUse = dest.getMaxDeliveryAttempts() == -1 ? this.defaultMaxDeliveryAttempts : dest.getMaxDeliveryAttempts();
                List dels = queue.recoverDeliveries(ids);
                Iterator iter2 = dels.iterator();
                Iterator iter3 = acks.iterator();
                while (iter2.hasNext()) {
                    Delivery del = (Delivery)iter2.next();
                    DeliveryRecovery info = (DeliveryRecovery)iter3.next();
                    long deliveryId = info.getDeliveryID();
                    maxDeliveryId = Math.max(maxDeliveryId, deliveryId);
                    if (this.trace) {
                        log.trace((Object)(this + " Recovered delivery " + deliveryId + ", " + del));
                    }
                    this.deliveries.put(new Long(deliveryId), new DeliveryRecord(del, dlqToUse, expiryQueueToUse, dest.getRedeliveryDelay(), maxDeliveryAttemptsToUse, queueName, this.supportsFailover, deliveryId));
                    if (!this.supportsFailover) continue;
                    this.postOffice.sendReplicateDeliveryMessage(queueName, this.id, del.getReference().getMessage().getMessageID(), deliveryId, false, true);
                }
            }
            for (Binding binding : this.postOffice.getAllBindings()) {
                if (!binding.queue.isClustered() || !binding.queue.isRecoverable()) continue;
                binding.queue.removeStrandedReferences(oldSessionID);
            }
            this.deliveryIdSequence = maxDeliveryId + 1L;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " recoverDeliveries");
        }
    }

    public void addTemporaryDestination(JBossDestination dest) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
            if (!dest.isTemporary()) {
                throw new InvalidDestinationException("Destination:" + dest + " is not a temporary destination");
            }
            this.connectionEndpoint.addTemporaryDestination(dest);
            int fullSize = this.connectionEndpoint.getDefaultTempQueueFullSize();
            int pageSize = this.connectionEndpoint.getDefaultTempQueuePageSize();
            int downCacheSize = this.connectionEndpoint.getDefaultTempQueueDownCacheSize();
            ManagedDestination mDest = dest.isTopic() ? new ManagedTopic(dest.getName(), fullSize, pageSize, downCacheSize, this.postOffice.isClustered()) : new ManagedQueue(dest.getName(), fullSize, pageSize, downCacheSize, this.postOffice.isClustered());
            mDest.setTemporary(true);
            this.dm.registerDestination(mDest);
            if (dest.isQueue()) {
                MessagingQueue coreQueue = new MessagingQueue(this.nodeId, dest.getName(), this.idm.getID(), this.ms, this.pm, false, -1, null, fullSize, pageSize, downCacheSize, this.postOffice.isClustered(), this.sp.getRecoverDeliveriesTimeout());
                JMSCondition cond = new JMSCondition(true, dest.getName());
                this.postOffice.addBinding(new Binding(cond, coreQueue, true), this.postOffice.isClustered());
                coreQueue.activate();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " addTemporaryDestination");
        }
    }

    public void deleteTemporaryDestination(JBossDestination dest) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
            if (!dest.isTemporary()) {
                throw new InvalidDestinationException("Destination:" + dest + " is not a temporary destination");
            }
            ManagedDestination mDest = this.dm.getDestination(dest.getName(), dest.isQueue());
            if (mDest == null) {
                throw new InvalidDestinationException("No such destination: " + dest);
            }
            if (dest.isQueue()) {
                Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
                if (binding == null) {
                    throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
                }
                if (binding.queue.getLocalDistributor().getNumberOfReceivers() != 0) {
                    throw new IllegalStateException("Cannot delete temporary queue if it has consumer(s)");
                }
                this.postOffice.removeBinding(dest.getName(), this.postOffice.isClustered());
            } else {
                Collection queues = this.postOffice.getQueuesForCondition(new JMSCondition(false, dest.getName()), true);
                if (!queues.isEmpty()) {
                    throw new IllegalStateException("Cannot delete temporary topic if it has consumer(s)");
                }
            }
            this.connectionEndpoint.removeTemporaryDestination(dest);
            this.dm.unregisterDestination(mDest);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " deleteTemporaryDestination");
        }
    }

    public void unsubscribe(String subscriptionName) throws JMSException {
        log.trace((Object)(this + " unsubscribing " + subscriptionName));
        try {
            Replicator rep;
            Map map;
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
            if (subscriptionName == null) {
                throw new InvalidDestinationException("Destination is null");
            }
            String clientID = this.connectionEndpoint.getClientID();
            if (clientID == null) {
                throw new JMSException("null clientID on connection");
            }
            String queueName = MessageQueueNameHelper.createSubscriptionName(clientID, subscriptionName);
            Binding binding = this.postOffice.getBindingForQueueName(queueName);
            if (binding == null) {
                throw new InvalidDestinationException("Cannot find durable subscription with name " + subscriptionName + " to unsubscribe");
            }
            Queue sub = binding.queue;
            if (sub.getLocalDistributor().getNumberOfReceivers() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + subscriptionName + " since it has active subscribers");
            }
            if (sub.isClustered() && this.postOffice.isClustered() && !(map = (rep = (Replicator)((Object)this.postOffice)).get((Serializable)((Object)sub.getName()))).isEmpty()) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + subscriptionName + " since it has active subscribers on other nodes");
            }
            this.postOffice.removeBinding(sub.getName(), sub.isClustered() && this.postOffice.isClustered());
            String counterName = "Subscription." + sub.getName();
            MessageCounter counter = this.sp.getMessageCounterManager().unregisterMessageCounter(counterName);
            if (counter == null) {
                throw new IllegalStateException("Cannot find counter to remove " + counterName);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " unsubscribe");
        }
    }

    public ServerConnectionEndpoint getConnectionEndpoint() {
        return this.connectionEndpoint;
    }

    public String toString() {
        return "SessionEndpoint[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverAnyWaitingDeliveries(String queueName) throws Exception {
        DeliveryRecord dr;
        if (this.trace) {
            log.trace((Object)("Delivering any waiting deliveries: " + queueName));
        }
        ArrayList<DeliveryRecord> toAddBack = null;
        while ((dr = (DeliveryRecord)this.toDeliver.poll(0L)) != null) {
            if (this.trace) {
                log.trace((Object)("Considering " + dr));
            }
            if (queueName == null || dr.queueName.equals(queueName)) {
                DeliveryRecord deliveryRecord = dr;
                synchronized (deliveryRecord) {
                    this.performDelivery(dr.del.getReference(), dr.deliveryID, dr.getConsumer());
                    dr.waitingForResponse = false;
                    continue;
                }
            }
            if (toAddBack == null) {
                toAddBack = new ArrayList<DeliveryRecord>();
            }
            toAddBack.add(dr);
        }
        if (toAddBack != null) {
            Iterator iter = toAddBack.iterator();
            while (iter.hasNext()) {
                this.toDeliver.put(iter.next());
            }
        }
        if (this.trace) {
            log.trace((Object)"Done delivering");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectDeliveries(Map map, boolean firstNode, String queueName) throws Exception {
        if (this.trace) {
            log.trace((Object)"Collecting deliveries");
        }
        boolean gotSome = false;
        if (!firstNode && this.replicating) {
            if (this.trace) {
                log.trace((Object)"Now collecting");
            }
            for (Map.Entry entry : this.deliveries.entrySet()) {
                Long l = (Long)entry.getKey();
                long deliveryID = l;
                DeliveryRecord rec = (DeliveryRecord)entry.getValue();
                if (!rec.replicating || queueName != null && !rec.queueName.equals(queueName)) continue;
                HashMap<Long, String> ids = (HashMap<Long, String>)map.get(rec.queueName);
                if (ids == null) {
                    ids = new HashMap<Long, String>();
                    map.put(rec.queueName, ids);
                }
                ids.put(new Long(rec.del.getReference().getMessage().getMessageID()), this.id);
                gotSome = true;
                boolean notify = false;
                Object object = rec;
                synchronized (object) {
                    if (rec.waitingForResponse) {
                        this.performDelivery(rec.del.getReference(), deliveryID, rec.getConsumer());
                        rec.waitingForResponse = false;
                        notify = true;
                    }
                }
                if (!notify) continue;
                object = this.deliveryLock;
                synchronized (object) {
                    if (this.waitingToClose) {
                        this.deliveryLock.notifyAll();
                    }
                }
            }
        }
        if (this.trace) {
            log.trace((Object)("Collected " + map.size() + " deliveries"));
        }
        return gotSome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replicateDeliveryResponseReceived(long deliveryID) throws Exception {
        DeliveryRecord rec;
        if (this.trace) {
            log.trace((Object)(this + " replicate delivery response received for delivery " + deliveryID));
        }
        if ((rec = (DeliveryRecord)this.deliveries.get(new Long(deliveryID))) == null) {
            return;
        }
        boolean delivered = false;
        while (true) {
            DeliveryRecord dr;
            if ((dr = (DeliveryRecord)this.toDeliver.peek()) == null) {
                if (!this.trace) break;
                log.trace((Object)"No more deliveries in list");
                break;
            }
            if (this.trace) {
                log.trace((Object)("Peeked delivery record: " + dr.deliveryID));
            }
            DeliveryRecord deliveryRecord = dr;
            synchronized (deliveryRecord) {
                boolean performDelivery;
                block16: {
                    performDelivery = false;
                    if (dr.waitingForResponse) {
                        if (dr == rec) {
                            if (this.trace) {
                                log.trace((Object)"Found our delivery");
                            }
                            performDelivery = true;
                            break block16;
                        } else {
                            if (!delivered) {
                            }
                            break;
                        }
                    }
                    if (this.trace) {
                        log.trace((Object)"Non replicated delivery");
                    }
                    performDelivery = true;
                }
                if (performDelivery) {
                    this.toDeliver.take();
                    this.performDelivery(dr.del.getReference(), dr.deliveryID, dr.getConsumer());
                    delivered = true;
                    dr.waitingForResponse = false;
                    delivered = true;
                }
            }
        }
        if (!delivered) return;
        Object object = this.deliveryLock;
        synchronized (object) {
            if (!this.waitingToClose) return;
            this.deliveryLock.notifyAll();
            return;
        }
    }

    void expireDelivery(Delivery del, Queue expiryQueue) throws Throwable {
        if (this.trace) {
            log.trace((Object)(this + " detected expired message " + del.getReference()));
        }
        if (expiryQueue != null) {
            if (this.trace) {
                log.trace((Object)(this + " sending expired message to expiry queue " + expiryQueue));
            }
            JBossMessage copy = this.makeCopyForDLQOrExpiry(true, del);
            this.moveInTransaction(copy, del, expiryQueue, true);
        } else {
            log.warn((Object)("No expiry queue has been configured so removing expired " + del.getReference()));
            del.acknowledge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowser(String browserId) throws Exception {
        Map map = this.browsers;
        synchronized (map) {
            if (this.browsers.remove(browserId) == null) {
                throw new IllegalStateException("Cannot find browser with id " + browserId + " to remove");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(String consumerId) throws Exception {
        Map map = this.consumers;
        synchronized (map) {
            if (this.consumers.remove(consumerId) == null && this.trace) {
                log.trace((Object)("Cannot find consumer with id " + consumerId + " to remove"));
            }
        }
    }

    void localClose() throws Throwable {
        this.localClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localClose(boolean isFromFailure) throws Throwable {
        HashMap browsersClone;
        Object consumer2;
        HashMap consumersClone;
        if (this.closed) {
            if (this.trace) {
                log.trace((Object)"Session is already closed. ");
            }
            return;
        }
        if (this.trace) {
            log.trace((Object)(this + " close()"));
        }
        Map map = this.consumers;
        synchronized (map) {
            consumersClone = new HashMap(this.consumers);
        }
        ArrayList<Channel> curChannels = new ArrayList<Channel>();
        for (Object consumer2 : consumersClone.values()) {
            curChannels.add(((ServerConsumerEndpoint)consumer2).getChannel());
            ((ServerConsumerEndpoint)consumer2).localClose();
        }
        this.consumers.clear();
        consumer2 = this.browsers;
        synchronized (consumer2) {
            browsersClone = new HashMap(this.browsers);
        }
        Iterator i = browsersClone.values().iterator();
        while (i.hasNext()) {
            ((ServerBrowserEndpoint)i.next()).localClose();
        }
        this.browsers.clear();
        Map map2 = this.deliveries;
        synchronized (map2) {
            ArrayList entries = new ArrayList(this.deliveries.entrySet());
            Collections.sort(entries, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    Map.Entry entry1 = (Map.Entry)obj1;
                    Map.Entry entry2 = (Map.Entry)obj2;
                    Long id1 = (Long)entry1.getKey();
                    Long id2 = (Long)entry2.getKey();
                    return id2.compareTo(id1);
                }
            });
            Iterator iter = entries.iterator();
            HashSet<DeliveryObserver> channels = new HashSet<DeliveryObserver>();
            if (this.trace) {
                log.trace((Object)(this + " cancelling " + entries.size() + " deliveries"));
            }
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (this.trace) {
                    log.trace((Object)(this + " cancelling delivery with delivery id: " + entry.getKey()));
                }
                DeliveryRecord rec = (DeliveryRecord)entry.getValue();
                if (rec.del.isSucked() && rec.del.getReference().getMessage().isReliable() && rec.getConsumer().getChannel().isRecoverable()) {
                    try {
                        this.pm.updateMessageState(rec.getConsumer().getChannelID(), rec.del.getReference(), DUR_SUB_STATE_CONSUMERS);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to update message " + rec.del.getReference() + " to state C"), (Throwable)e);
                        continue;
                    }
                }
                if (!rec.del.isXAPrepared()) {
                    rec.del.cancel();
                }
                channels.add(rec.del.getObserver());
                if (!isFromFailure) continue;
                this.failureCanceledDels.put(rec.deliveryID, rec.deliveryID);
            }
            if (this.isSuckerSession.get()) {
                for (Channel ch : curChannels) {
                    List<PersistenceManager.ReferenceInfo> refs = this.pm.claimMessagesInSuck(ch.getChannelID());
                    if (refs.size() <= 0) continue;
                    ArrayList<Long> mids = new ArrayList<Long>();
                    HashMap<Long, PersistenceManager.ReferenceInfo> refInfoMap = new HashMap<Long, PersistenceManager.ReferenceInfo>();
                    for (PersistenceManager.ReferenceInfo refInfo : refs) {
                        mids.add(refInfo.getMessageId());
                        refInfoMap.put(refInfo.getMessageId(), refInfo);
                    }
                    List messages = this.pm.getMessages(mids);
                    for (Message m : messages) {
                        MessageReference mref = this.ms.reference(m);
                        PersistenceManager.ReferenceInfo mInfo = (PersistenceManager.ReferenceInfo)refInfoMap.get(m.getMessageID());
                        mref.setDeliveryCount(mInfo.getDeliveryCount());
                        mref.setScheduledDeliveryTime(mInfo.getScheduledDelivery());
                        SimpleDelivery del = new SimpleDelivery(ch, mref, true, true);
                        del.cancel();
                    }
                }
            }
            this.promptDelivery(channels);
            this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
            this.deliveries.clear();
        }
        this.sp.removeSession(this.id);
        Dispatcher.instance.unregisterTarget(this.id, this);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelivery(long deliveryId) throws Throwable {
        DeliveryRecord rec = null;
        Map map = this.deliveries;
        synchronized (map) {
            rec = (DeliveryRecord)this.deliveries.remove(new Long(deliveryId));
        }
        if (rec == null) {
            throw new IllegalStateException("Cannot find delivery to cancel " + deliveryId);
        }
        rec.del.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForDeliveriesFromConsumer(String consumerID) throws Exception {
        long toWait = 5000L;
        Object object = this.deliveryLock;
        synchronized (object) {
            boolean wait;
            do {
                wait = false;
                long start = System.currentTimeMillis();
                for (DeliveryRecord rec : this.deliveries.values()) {
                    ServerConsumerEndpoint consumer = rec.getConsumer();
                    if (consumer == null || !consumer.getID().equals(consumerID) || !rec.waitingForResponse) continue;
                    wait = true;
                    break;
                }
                if (!wait) continue;
                this.waitingToClose = true;
                try {
                    this.deliveryLock.wait(toWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                toWait -= System.currentTimeMillis() - start;
            } while (wait && toWait > 0L);
            if (toWait <= 0L) {
                while (this.toDeliver.poll(0L) != null) {
                }
                log.warn((Object)"Timed out waiting for response to arrive");
            }
            this.waitingToClose = false;
        }
    }

    synchronized void handleDelivery(Delivery delivery, ServerConsumerEndpoint consumer) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " handling delivery " + delivery));
        }
        DeliveryRecord rec = null;
        long deliveryId = this.deliveryIdSequence++;
        if (this.trace) {
            log.trace((Object)("Delivery id is now " + deliveryId));
        }
        if (consumer.isRetainDeliveries()) {
            rec = new DeliveryRecord(delivery, consumer, deliveryId);
            this.deliveries.put(new Long(deliveryId), rec);
            if (this.trace) {
                log.trace((Object)(this + " added delivery " + deliveryId + ": " + delivery));
            }
        } else {
            try {
                if (this.trace) {
                    log.trace((Object)"Acknowledging delivery now");
                }
                delivery.acknowledge(null);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to acknowledge delivery", t);
            }
        }
        Message message = delivery.getReference().getMessage();
        if (!consumer.isReplicating() || !this.replicating) {
            if (this.trace) {
                log.trace((Object)(this + " doing the delivery straight away"));
            }
            this.performDelivery(delivery.getReference(), deliveryId, consumer);
        } else if (!message.isReliable()) {
            if (!this.toDeliver.isEmpty()) {
                if (this.trace) {
                    log.trace((Object)"Message is unreliable and there are refs in the toDeliver so adding to list");
                }
                this.toDeliver.put((Object)rec);
                if (this.toDeliver.peek() == rec) {
                    this.toDeliver.take();
                    this.performDelivery(delivery.getReference(), deliveryId, consumer);
                }
            } else {
                if (this.trace) {
                    log.trace((Object)"Message is unreliable, but no deliveries in list so performing delivery now");
                }
                this.performDelivery(delivery.getReference(), deliveryId, consumer);
            }
        } else if (!this.postOffice.isFirstNode()) {
            if (this.trace) {
                log.trace((Object)(this + " deferring delivery until we know it's been replicated"));
            }
            rec.waitingForResponse = true;
            this.toDeliver.put((Object)rec);
            this.postOffice.sendReplicateDeliveryMessage(consumer.getQueueName(), this.id, delivery.getReference().getMessage().getMessageID(), deliveryId, true, false);
        } else {
            rec.waitingForResponse = false;
            if (this.trace) {
                log.trace((Object)"First node so actually doing delivery now");
            }
            this.performDelivery(delivery.getReference(), deliveryId, consumer);
        }
    }

    void performDelivery(MessageReference ref, long deliveryID, ServerConsumerEndpoint consumer) {
        if (consumer == null) {
            if (this.trace) {
                log.trace((Object)(this + " consumer is null, cannot perform delivery"));
            }
            return;
        }
        if (consumer.isDead()) {
            return;
        }
        if (this.trace) {
            log.trace((Object)(this + " performing delivery for " + ref));
        }
        ClientDelivery del = new ClientDelivery(ref.getMessage(), consumer.getID(), deliveryID, ref.getDeliveryCount());
        Callback callback = new Callback((Object)del);
        try {
            if (this.trace) {
                log.trace((Object)(this + " submitting message " + ref.getMessage() + " to the remoting layer to be sent asynchronously"));
            }
            this.callbackHandler.handleCallbackOneway(callback);
            consumer.setLastDeliveryID(deliveryID);
        }
        catch (Throwable t) {
            log.trace((Object)(this + " failed to handle callback"), t);
            consumer.setStarted(false);
            consumer.setDead();
        }
    }

    void acknowledgeTransactionally(List acks, Transaction tx) throws Throwable {
        DeliveryCallback deliveryCallback;
        if (this.trace) {
            log.trace((Object)(this + " acknowledging transactionally " + acks.size() + " messages for " + tx));
        }
        if ((deliveryCallback = (DeliveryCallback)tx.getCallback(this)) == null) {
            deliveryCallback = new DeliveryCallback();
            tx.addCallback(deliveryCallback, this);
        }
        for (Ack ack : acks) {
            Long id = new Long(ack.getDeliveryID());
            if (ack instanceof DeliveryInfo && !((DeliveryInfo)ack).isShouldAck()) continue;
            DeliveryRecord rec = (DeliveryRecord)this.deliveries.get(id);
            if (rec == null) {
                log.warn((Object)("Cannot find delivery to acknowledge " + ack));
                continue;
            }
            deliveryCallback.addDeliveryId(id);
            rec.del.acknowledge(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStarted(boolean s) throws Throwable {
        HashMap consumersClone;
        Map map = this.consumers;
        synchronized (map) {
            consumersClone = new HashMap(this.consumers);
        }
        for (ServerConsumerEndpoint sce : consumersClone.values()) {
            if (s) {
                sce.start();
                continue;
            }
            sce.stop();
        }
    }

    void promptDelivery(final Channel channel) {
        if (this.trace) {
            log.trace((Object)("Prompting delivery on " + channel));
        }
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    channel.deliver();
                }
            });
        }
        catch (Throwable t) {
            log.error((Object)"Failed to prompt delivery", t);
        }
    }

    void validateDestination(JBossDestination jmsDestination) throws InvalidDestinationException {
        if (this.dm.getDestination(jmsDestination.getName(), jmsDestination.isQueue()) == null) {
            throw new InvalidDestinationException("No such destination: " + jmsDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Delivery cancelDeliveryInternal(Cancel cancel) throws Throwable {
        DeliveryRecord rec = null;
        Map map = this.deliveries;
        synchronized (map) {
            rec = (DeliveryRecord)this.deliveries.remove(new Long(cancel.getDeliveryId()));
            if (rec == null) {
                if (this.trace) {
                    log.trace((Object)"Cannot find delivery to cancel, session probably failed over and is not replicated");
                }
                return null;
            }
            if (rec.del.isSucked() && rec.del.getReference().getMessage().isReliable() && rec.getConsumer().getChannel().isRecoverable()) {
                try {
                    this.pm.updateMessageState(rec.getConsumer().getChannelID(), rec.del.getReference(), DUR_SUB_STATE_CONSUMERS);
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)("Failed to update message " + rec.del.getReference() + " to state C"));
                    }
                    return null;
                }
            }
        }
        boolean expired = cancel.isExpired() || rec.del.getReference().getMessage().isExpired();
        boolean reachedMaxDeliveryAttempts = cancel.isReachedMaxDeliveryAttempts() || cancel.getDeliveryCount() >= rec.maxDeliveryAttempts;
        Delivery del = rec.del;
        if (!expired && !reachedMaxDeliveryAttempts) {
            del.getReference().setDeliveryCount(cancel.getDeliveryCount());
            if (rec.redeliveryDelay != 0L) {
                del.getReference().setScheduledDeliveryTime(System.currentTimeMillis() + rec.redeliveryDelay);
            }
            if (this.trace) {
                log.trace((Object)("Cancelling delivery " + cancel.getDeliveryId()));
            }
            del.cancel();
        } else if (expired) {
            if (this.debug) {
                log.debug((Object)("Sending expired message: " + rec.del.getReference() + " to expiry queue " + rec.expiryQueue));
            }
            JBossMessage copy = this.makeCopyForDLQOrExpiry(true, del);
            this.moveInTransaction(copy, del, rec.expiryQueue, false);
        } else {
            if (this.debug) {
                log.debug((Object)("Sending message: " + rec.del.getReference() + " to dlq " + rec.dlq));
            }
            JBossMessage copy = this.makeCopyForDLQOrExpiry(false, del);
            this.moveInTransaction(copy, del, rec.dlq, true);
        }
        this.postOffice.sendReplicateAckMessage(rec.queueName, del.getReference().getMessage().getMessageID());
        return rec.del;
    }

    private JBossMessage makeCopyForDLQOrExpiry(boolean expiry, Delivery del) throws Exception {
        if (this.trace) {
            log.trace((Object)("Making copy of message for DLQ or expiry " + del));
        }
        JBossMessage msg = (JBossMessage)del.getReference().getMessage();
        JBossMessage copy = msg.doCopy();
        long newMessageId = this.sp.getMessageIDManager().getID();
        copy.setMessageId(newMessageId);
        copy.setExpiration(0L);
        String origMessageId = msg.getJMSMessageID();
        String origDest = msg.getJMSDestination().toString();
        copy.setStringProperty("JBM_ORIG_MESSAGE_ID", origMessageId);
        copy.setStringProperty("JBM_ORIG_DESTINATION", origDest);
        if (expiry) {
            long actualExpiryTime = System.currentTimeMillis();
            copy.setLongProperty("JBM_ACTUAL_EXPIRY", actualExpiryTime);
        }
        return copy;
    }

    private void moveInTransaction(JBossMessage msg, Delivery del, Queue queue, boolean dlq) throws Throwable {
        Transaction tx = this.tr.createTransaction();
        MessageReference ref = msg.createReference();
        try {
            if (queue != null) {
                queue.handle(null, ref, tx);
                del.acknowledge(tx);
            } else {
                log.warn((Object)("No " + (dlq ? "DLQ" : "expiry queue") + " has been specified so the message will be removed"));
                del.acknowledge(tx);
            }
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw t;
        }
        if (queue != null) {
            this.promptDelivery(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acknowledgeDeliveryInternal(Ack ack) throws Throwable {
        if (this.trace) {
            log.trace((Object)(this + " acknowledging delivery " + ack));
        }
        DeliveryRecord rec = null;
        Map map = this.deliveries;
        synchronized (map) {
            rec = (DeliveryRecord)this.deliveries.remove(new Long(ack.getDeliveryID()));
            if (rec == null) {
                if (this.failureCanceledDels.remove(ack.getDeliveryID()) != null) {
                    throw new JMSException("Message already canceled before this ack " + ack + " and the message will be redelivered.");
                }
                log.debug((Object)("Cannot find " + ack + " to acknowledge, it was probably acknowledged before"));
                return false;
            }
        }
        ServerConsumerEndpoint consumer = rec.getConsumer();
        if (consumer != null && consumer.isRemote()) {
            rec.del.getObserver().acknowledgeNoPersist(rec.del);
        } else {
            rec.del.acknowledge(null);
        }
        if (rec.replicating && this.replicating) {
            this.postOffice.sendReplicateAckMessage(rec.queueName, rec.del.getReference().getMessage().getMessageID());
        }
        if (this.trace) {
            log.trace((Object)(this + " acknowledged delivery " + ack));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerDelegate createConsumerDelegateDirect(String queueName, String selectorString) throws Throwable {
        ConsumerAdvised advised;
        Binding binding;
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
        if ("".equals(selectorString)) {
            selectorString = null;
        }
        if (this.trace) {
            log.trace((Object)(this + " creating direct consumer for " + queueName + (selectorString == null ? "" : ", selector '" + selectorString + "'")));
        }
        if ((binding = this.postOffice.getBindingForQueueName(queueName)) == null) {
            throw new IllegalArgumentException("Cannot find queue with name " + queueName);
        }
        String consumerID = GUIDGenerator.generateGUID();
        int prefetchSize = this.connectionEndpoint.getPrefetchSize();
        JBossQueue dest = new JBossQueue(queueName);
        ServerConsumerEndpoint ep = new ServerConsumerEndpoint(consumerID, binding.queue, binding.queue.getName(), this, selectorString, false, dest, null, null, 0L, 1, true, false, prefetchSize);
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            advised = new ConsumerAdvised(ep);
        }
        Dispatcher.instance.registerTarget(consumerID, advised);
        ClientConsumerDelegate stub = new ClientConsumerDelegate(consumerID, prefetchSize, -1, 0L);
        Map map = this.consumers;
        synchronized (map) {
            this.consumers.put(consumerID, ep);
        }
        log.trace((Object)(this + " created and registered " + ep));
        this.isSuckerSession.set(true);
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerDelegate createConsumerDelegateInternal(JBossDestination jmsDestination, String selectorString, boolean noLocal, String subscriptionName) throws Throwable {
        ConsumerAdvised advised;
        Object counter;
        Queue queue;
        ManagedDestination mDest;
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
        if ("".equals(selectorString)) {
            selectorString = null;
        }
        if (this.trace) {
            log.trace((Object)(this + " creating consumer for " + jmsDestination + (selectorString == null ? "" : ", selector '" + selectorString + "'") + (subscriptionName == null ? "" : ", subscription '" + subscriptionName + "'") + (noLocal ? ", noLocal" : "")));
        }
        if ((mDest = this.dm.getDestination(jmsDestination.getName(), jmsDestination.isQueue())) == null) {
            throw new InvalidDestinationException("No such destination: " + jmsDestination + " has it been deployed?");
        }
        if (jmsDestination.isTemporary() && !this.connectionEndpoint.hasTemporaryDestination(jmsDestination)) {
            String msg = "Cannot create a message consumer on a different connection to that which created the temporary destination";
            throw new IllegalStateException(msg);
        }
        String consumerID = GUIDGenerator.generateGUID();
        Selector selector = null;
        if (selectorString != null) {
            selector = new Selector(selectorString);
        }
        if (jmsDestination.isTopic()) {
            if (subscriptionName == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " creating new non-durable subscription on " + jmsDestination));
                }
                queue = new MessagingQueue(this.nodeId, GUIDGenerator.generateGUID(), this.idm.getID(), this.ms, this.pm, false, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
                JMSCondition topicCond = new JMSCondition(false, jmsDestination.getName());
                this.postOffice.addBinding(new Binding(topicCond, queue, false), false);
                queue.activate();
                String counterName = "Subscription." + queue.getName();
                int dayLimitToUse = mDest.getMessageCounterHistoryDayLimit();
                if (dayLimitToUse == -1) {
                    dayLimitToUse = this.sp.getDefaultMessageCounterHistoryDayLimit();
                }
                if (!mDest.isTemporary()) {
                    MessageCounter counter2 = new MessageCounter(counterName, null, queue, true, false, dayLimitToUse);
                    this.sp.getMessageCounterManager().registerMessageCounter(counterName, counter2);
                }
            } else {
                String counterName;
                if (jmsDestination.isTemporary()) {
                    throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                }
                String clientID = this.connectionEndpoint.getClientID();
                if (clientID == null) {
                    throw new JMSException("Cannot create durable subscriber without a valid client ID");
                }
                String name = MessageQueueNameHelper.createSubscriptionName(clientID, subscriptionName);
                Binding binding = this.postOffice.getBindingForQueueName(name);
                if (binding == null) {
                    if (this.trace) {
                        log.trace((Object)(this + " creating new durable subscription on " + jmsDestination));
                    }
                    queue = new MessagingQueue(this.nodeId, name, this.idm.getID(), this.ms, this.pm, true, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
                    this.postOffice.addBinding(new Binding(new JMSCondition(false, jmsDestination.getName()), queue, true), this.postOffice.isClustered() && mDest.isClustered());
                    queue.activate();
                    if (!mDest.isTemporary()) {
                        counterName = "Subscription." + queue.getName();
                        MessageCounter counter3 = new MessageCounter(counterName, subscriptionName, queue, true, true, mDest.getMessageCounterHistoryDayLimit());
                        this.sp.getMessageCounterManager().registerMessageCounter(counterName, counter3);
                    }
                } else {
                    String oldTopicName;
                    boolean topicChanged;
                    boolean selectorChanged;
                    queue = binding.queue;
                    if (this.trace) {
                        log.trace((Object)(this + " subscription " + subscriptionName + " already exists"));
                    }
                    if (queue.getLocalDistributor().getNumberOfReceivers() > 0 && !mDest.isClustered()) {
                        throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                    }
                    counterName = "Subscription." + queue.getName();
                    boolean createCounter = false;
                    if (this.sp.getMessageCounterManager().getMessageCounter(counterName) == null) {
                        createCounter = true;
                    }
                    String filterString = queue.getFilter() != null ? queue.getFilter().getFilterString() : null;
                    boolean bl = selectorChanged = selectorString == null && filterString != null || filterString == null && selectorString != null || filterString != null && selectorString != null && !filterString.equals(selectorString);
                    if (this.trace) {
                        log.trace((Object)("selector " + (selectorChanged ? "has" : "has NOT") + " changed"));
                    }
                    boolean bl2 = topicChanged = !(oldTopicName = ((JMSCondition)binding.condition).getName()).equals(jmsDestination.getName());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("topic " + (topicChanged ? "has" : "has NOT") + " changed"));
                    }
                    if (selectorChanged || topicChanged) {
                        if (this.trace) {
                            log.trace((Object)"topic or selector changed so deleting old subscription");
                        }
                        this.postOffice.removeBinding(queue.getName(), this.postOffice.isClustered() && mDest.isClustered());
                        queue = new MessagingQueue(this.nodeId, name, this.idm.getID(), this.ms, this.pm, true, mDest.getMaxSize(), selector, mDest.getFullSize(), mDest.getPageSize(), mDest.getDownCacheSize(), mDest.isClustered(), this.sp.getRecoverDeliveriesTimeout());
                        this.postOffice.addBinding(new Binding(new JMSCondition(false, jmsDestination.getName()), queue, true), this.postOffice.isClustered() && mDest.isClustered());
                        queue.activate();
                        if (!mDest.isTemporary()) {
                            createCounter = true;
                        }
                    }
                    if (createCounter) {
                        counter = new MessageCounter(counterName, subscriptionName, queue, true, true, mDest.getMessageCounterHistoryDayLimit());
                        this.sp.getMessageCounterManager().registerMessageCounter(counterName, (MessageCounter)counter);
                    }
                }
            }
        } else {
            queue = this.postOffice.getBindingForQueueName((String)jmsDestination.getName()).queue;
            if (queue == null) {
                throw new IllegalStateException("Cannot find queue: " + jmsDestination.getName());
            }
        }
        int prefetchSize = this.connectionEndpoint.getPrefetchSize();
        Queue dlqToUse = mDest.getDLQ() == null ? this.defaultDLQ : mDest.getDLQ();
        Queue expiryQueueToUse = mDest.getExpiryQueue() == null ? this.defaultExpiryQueue : mDest.getExpiryQueue();
        int maxDeliveryAttemptsToUse = mDest.getMaxDeliveryAttempts() == -1 ? this.defaultMaxDeliveryAttempts : mDest.getMaxDeliveryAttempts();
        long redeliveryDelayToUse = mDest.getRedeliveryDelay() == -1L ? this.defaultRedeliveryDelay : mDest.getRedeliveryDelay();
        boolean replicating = this.supportsFailover && queue.isClustered() && (!jmsDestination.isTopic() || queue.isRecoverable());
        ServerConsumerEndpoint ep = new ServerConsumerEndpoint(consumerID, queue, queue.getName(), this, selectorString, noLocal, jmsDestination, dlqToUse, expiryQueueToUse, redeliveryDelayToUse, maxDeliveryAttemptsToUse, false, replicating, prefetchSize);
        if (queue.isClustered() && this.postOffice.isClustered() && jmsDestination.isTopic() && subscriptionName != null) {
            Replicator rep = (Replicator)((Object)this.postOffice);
            rep.put((Serializable)((Object)queue.getName()), (Serializable)((Object)DUR_SUB_STATE_CONSUMERS));
        }
        counter = AspectManager.instance();
        synchronized (counter) {
            advised = new ConsumerAdvised(ep);
        }
        Dispatcher.instance.registerTarget(consumerID, advised);
        ClientConsumerDelegate stub = new ClientConsumerDelegate(consumerID, prefetchSize, maxDeliveryAttemptsToUse, redeliveryDelayToUse);
        Map map = this.consumers;
        synchronized (map) {
            this.consumers.put(consumerID, ep);
        }
        log.trace((Object)(this + " created and registered " + ep));
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserDelegate createBrowserDelegateInternal(JBossDestination jmsDestination, String selector) throws Throwable {
        BrowserAdvised advised;
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
        if (jmsDestination == null) {
            throw new InvalidDestinationException("null destination");
        }
        if (jmsDestination.isTopic()) {
            throw new IllegalStateException("Cannot browse a topic");
        }
        this.validateDestination(jmsDestination);
        log.trace((Object)(this + " creating browser for " + jmsDestination + (selector == null ? "" : ", selector '" + selector + "'")));
        Binding binding = this.postOffice.getBindingForQueueName(jmsDestination.getName());
        if (binding == null) {
            throw new IllegalStateException("Cannot find queue with name " + jmsDestination.getName());
        }
        String browserID = GUIDGenerator.generateGUID();
        ServerBrowserEndpoint ep = new ServerBrowserEndpoint(this, browserID, binding.queue, selector, jmsDestination);
        Map map = this.browsers;
        synchronized (map) {
            this.browsers.put(browserID, ep);
        }
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            advised = new BrowserAdvised(ep);
        }
        Dispatcher.instance.registerTarget(browserID, advised);
        ClientBrowserDelegate stub = new ClientBrowserDelegate(browserID);
        log.trace((Object)(this + " created and registered " + ep));
        return stub;
    }

    private void promptDelivery(Set channels) {
        for (DeliveryObserver observer : channels) {
            this.promptDelivery((Channel)observer);
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    private class DeliveryCallback
    implements TxCallback {
        List delList = new ArrayList();

        private DeliveryCallback() {
        }

        public void beforePrepare() {
        }

        public void beforeCommit(boolean onePhase) {
        }

        public void beforeRollback(boolean onePhase) {
        }

        public void afterPrepare() {
        }

        public synchronized void afterCommit(boolean onePhase) throws TransactionException {
            for (Long deliveryId : this.delList) {
                DeliveryRecord del = (DeliveryRecord)ServerSessionEndpoint.this.deliveries.remove(deliveryId);
                if (del == null || !del.replicating) continue;
                try {
                    ServerSessionEndpoint.this.postOffice.sendReplicateAckMessage(del.queueName, del.del.getReference().getMessage().getMessageID());
                }
                catch (Exception e) {
                    throw new TransactionException("Failed to handle send ack", e);
                }
            }
        }

        public void afterRollback(boolean onePhase) throws TransactionException {
        }

        synchronized void addDeliveryId(Long deliveryId) {
            this.delList.add(deliveryId);
        }
    }

    private static class DeliveryRecord {
        Delivery del;
        Queue dlq;
        Queue expiryQueue;
        long redeliveryDelay;
        int maxDeliveryAttempts;
        WeakReference consumerRef;
        String queueName;
        boolean replicating;
        volatile boolean waitingForResponse;
        long deliveryID;

        ServerConsumerEndpoint getConsumer() {
            if (this.consumerRef != null) {
                return (ServerConsumerEndpoint)this.consumerRef.get();
            }
            return null;
        }

        DeliveryRecord(Delivery del, Queue dlq, Queue expiryQueue, long redeliveryDelay, int maxDeliveryAttempts, String queueName, boolean replicating, long deliveryID) {
            this.del = del;
            this.dlq = dlq;
            this.expiryQueue = expiryQueue;
            this.redeliveryDelay = redeliveryDelay;
            this.maxDeliveryAttempts = maxDeliveryAttempts;
            this.queueName = queueName;
            this.replicating = replicating;
            this.deliveryID = deliveryID;
        }

        DeliveryRecord(Delivery del, ServerConsumerEndpoint consumer, long deliveryID) {
            this(del, consumer.getDLQ(), consumer.getExpiryQueue(), consumer.getRedliveryDelay(), consumer.getMaxDeliveryAttempts(), consumer.getQueueName(), consumer.isReplicating(), deliveryID);
            this.consumerRef = new WeakReference<ServerConsumerEndpoint>(consumer);
        }

        public String toString() {
            return "DeliveryRecord " + System.identityHashCode(this) + " del: " + this.del + " queueName: " + this.queueName;
        }
    }
}

