/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.FailoverListener;
import org.jboss.jms.client.JBossConnectionMetaData;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.tx.ResourceManagerFactory;

public class ConnectionAspect {
    protected JBossConnectionMetaData connMetaData;
    protected ConnectionState state;
    private String id;

    public Object handleGetClientID(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        currentState.setJustCreated(false);
        if (currentState.getClientID() == null) {
            currentState.setClientID((String)invocation.invokeNext());
        }
        return currentState.getClientID();
    }

    public Object handleSetClientID(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        if (currentState.getClientID() != null) {
            throw new IllegalStateException("Client id has already been set");
        }
        if (!currentState.isJustCreated()) {
            throw new IllegalStateException("setClientID can only be called directly after the connection is created");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        currentState.setClientID((String)mi.getArguments()[0]);
        currentState.setJustCreated(false);
        return invocation.invokeNext();
    }

    public Object handleGetExceptionListener(Invocation invocation) throws Throwable {
        ConnectionState state = this.getConnectionState(invocation);
        state.setJustCreated(false);
        return state.getRemotingConnection().getConnectionListener().getJMSExceptionListener();
    }

    public Object handleSetExceptionListener(Invocation invocation) throws Throwable {
        ConnectionState state = this.getConnectionState(invocation);
        state.setJustCreated(false);
        MethodInvocation mi = (MethodInvocation)invocation;
        ExceptionListener exceptionListener = (ExceptionListener)mi.getArguments()[0];
        state.getRemotingConnection().getConnectionListener().addJMSExceptionListener(exceptionListener);
        return null;
    }

    public Object handleGetConnectionMetaData(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        currentState.setJustCreated(false);
        if (this.connMetaData == null) {
            ClientConnectionDelegate delegate = (ClientConnectionDelegate)invocation.getTargetObject();
            this.connMetaData = new JBossConnectionMetaData(((ConnectionState)delegate.getState()).getVersionToUse());
        }
        return this.connMetaData;
    }

    public Object handleStart(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        currentState.setStarted(true);
        currentState.setJustCreated(false);
        return invocation.invokeNext();
    }

    public Object handleStop(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        currentState.setStarted(false);
        currentState.setJustCreated(false);
        return invocation.invokeNext();
    }

    public Object handleCreateSessionDelegate(Invocation invocation) throws Throwable {
        ConnectionState currentState = this.getConnectionState(invocation);
        currentState.setJustCreated(false);
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleClose(Invocation invocation) throws Throwable {
        try {
            Object ret;
            Object object = ret = invocation.invokeNext();
            Object var5_4 = null;
            ConnectionState state = this.getConnectionState(invocation);
            JMSRemotingConnection remotingConnection = state.getRemotingConnection();
            ConsolidatedRemotingConnectionListener l = remotingConnection.removeConnectionListener();
            if (l != null) {
                l.clear();
            }
            remotingConnection.stop();
            ResourceManagerFactory.instance.checkInResourceManager(state.getServerID());
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ConnectionState state = this.getConnectionState(invocation);
            JMSRemotingConnection remotingConnection = state.getRemotingConnection();
            ConsolidatedRemotingConnectionListener l = remotingConnection.removeConnectionListener();
            if (l != null) {
                l.clear();
            }
            remotingConnection.stop();
            ResourceManagerFactory.instance.checkInResourceManager(state.getServerID());
            throw throwable;
        }
    }

    public Object handleRegisterFailoverListener(Invocation invocation) throws Throwable {
        ConnectionState state = this.getConnectionState(invocation);
        MethodInvocation mi = (MethodInvocation)invocation;
        FailoverListener listener = (FailoverListener)mi.getArguments()[0];
        state.getFailoverCommandCenter().registerFailoverListener(listener);
        return null;
    }

    public Object handleUnregisterFailoverListener(Invocation invocation) throws Throwable {
        ConnectionState state = this.getConnectionState(invocation);
        MethodInvocation mi = (MethodInvocation)invocation;
        FailoverListener listener = (FailoverListener)mi.getArguments()[0];
        boolean result = state.getFailoverCommandCenter().unregisterFailoverListener(listener);
        return new Boolean(result);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConnectionAspect[");
        if (this.id == null) {
            sb.append("UNINITIALIZED]");
        } else {
            sb.append(this.id).append("]");
        }
        return sb.toString();
    }

    private ConnectionState getConnectionState(Invocation invocation) {
        if (this.state == null) {
            ClientConnectionDelegate currentDelegate = (ClientConnectionDelegate)invocation.getTargetObject();
            this.state = (ConnectionState)currentDelegate.getState();
            this.id = this.state.getDelegate().getID();
        }
        return this.state;
    }
}

