/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.HashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.Closeable;
import org.jboss.jms.client.container.DelegateIdentity;
import org.jboss.jms.client.container.ThreadValveCounter;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.logging.Logger;

public class ClosedInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ClosedInterceptor.class);
    private static final int NOT_CLOSED = 0;
    private static final int IN_CLOSING = 1;
    private static final int CLOSING = 2;
    private static final int IN_CLOSE = 3;
    private static final int CLOSED = -1;
    private boolean trace = log.isTraceEnabled();
    private volatile int state = 0;
    private ThreadValveCounter threadCounter = new ThreadValveCounter();
    private DelegateIdentity id = null;

    public static String stateToString(int state) {
        return state == 0 ? "NOT_CLOSED" : (state == 1 ? "IN_CLOSING" : (state == 2 ? "CLOSING" : (state == 3 ? "IN_CLOSE" : (state == -1 ? "CLOSED" : "UNKNOWN"))));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClosedInterceptor.");
        if (this.id == null) {
            sb.append("UNINITIALIZED");
        } else {
            sb.append(this.id.getType()).append("[").append(this.id.getID()).append("]");
        }
        return sb.toString();
    }

    public String getName() {
        return "ClosedInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        block25: {
            boolean isClose;
            block22: {
                if (this.id == null) {
                    this.id = DelegateIdentity.getIdentity(invocation);
                }
                String methodName = ((MethodInvocation)invocation).getMethod().getName();
                boolean isClosing = methodName.equals("closing");
                isClose = methodName.equals("close");
                if (isClosing) {
                    if (this.checkClosingAlreadyDone()) {
                        return new Long(-1L);
                    }
                } else if (isClose) {
                    if (this.checkCloseAlreadyDone()) {
                        return null;
                    }
                } else {
                    if (this.state == 3 || this.state == -1) {
                        log.error((Object)(this + ": method " + methodName + "() did not go through, " + "the interceptor is " + ClosedInterceptor.stateToString(this.state)));
                        throw new IllegalStateException("The object is closed");
                    }
                    this.threadCounter.pushThread();
                }
                if (isClosing) {
                    this.maintainRelatives(invocation);
                }
                try {
                    object = invocation.invokeNext();
                    Object var8_7 = null;
                    if (!isClosing) break block22;
                    this.removeSelf(invocation);
                }
                catch (Exception t) {
                    block23: {
                        Long l;
                        block26: {
                            block24: {
                                try {
                                    if (!isClosing && !isClose) break block23;
                                    l = new Long(-1L);
                                    Object var8_8 = null;
                                    if (!isClosing) break block24;
                                    this.removeSelf(invocation);
                                }
                                catch (Throwable throwable) {
                                    Object var8_9 = null;
                                    if (isClosing) {
                                        this.removeSelf(invocation);
                                        this.closing();
                                    } else if (isClose) {
                                        this.closed();
                                    } else {
                                        this.threadCounter.popThread();
                                    }
                                    throw throwable;
                                }
                                this.closing();
                                break block26;
                            }
                            if (isClose) {
                                this.closed();
                            } else {
                                this.threadCounter.popThread();
                            }
                        }
                        return l;
                    }
                    throw t;
                }
                this.closing();
                break block25;
            }
            if (isClose) {
                this.closed();
            } else {
                this.threadCounter.popThread();
            }
        }
        return object;
    }

    protected synchronized boolean checkClosingAlreadyDone() throws Throwable {
        if (this.state != 0) {
            return true;
        }
        this.state = 1;
        return false;
    }

    protected synchronized void closing() throws Throwable {
        this.state = 2;
    }

    protected boolean checkCloseAlreadyDone() throws Throwable {
        if (this.state != 2) {
            return true;
        }
        this.threadCounter.waitForCompletion();
        this.state = 3;
        return false;
    }

    protected synchronized void closed() throws Throwable {
        this.state = -1;
        log.trace((Object)(this + " closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maintainRelatives(Invocation invocation) {
        HashSet clone;
        HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
        Set children = state.getChildren();
        if (children == null) {
            if (this.trace) {
                log.trace((Object)(this + " has no children"));
            }
            return;
        }
        Set set = children;
        synchronized (set) {
            clone = new HashSet(children);
        }
        for (HierarchicalState child : clone) {
            Closeable del = (Closeable)((Object)child.getDelegate());
            try {
                del.closing(-1L);
                del.close();
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace((Object)"Failed to close", t);
            }
        }
    }

    protected void removeSelf(Invocation invocation) {
        HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
        HierarchicalState parent = state.getParent();
        if (parent != null) {
            parent.getChildren().remove(state);
        }
    }
}

