/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.EncodingUtil;

public class URIUtil {
    protected static final BitSet empty = new BitSet(1);

    public static String getName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = URIUtil.getPath(string);
        int n = string2.lastIndexOf("/");
        int n2 = string2.length();
        return n >= 0 ? string2.substring(n + 1, n2) : string2;
    }

    public static String getQuery(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf("/", n >= 0 ? (string.lastIndexOf("/", n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        n = string.indexOf("?", n2);
        if (n < 0) {
            return null;
        }
        n2 = n + 1;
        if (string.lastIndexOf("#") > n2) {
            n3 = string.lastIndexOf("#");
        }
        return n2 < 0 || n2 == n3 ? null : string.substring(n2, n3);
    }

    public static String getPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf("/", n >= 0 ? (string.lastIndexOf("/", n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        if (string.indexOf(63, n2) != -1) {
            n3 = string.indexOf(63, n2);
        }
        if (string.lastIndexOf("#") > n2 && string.lastIndexOf("#") < n3) {
            n3 = string.lastIndexOf("#");
        }
        return n2 < 0 ? (n >= 0 ? "/" : string) : string.substring(n2, n3);
    }

    public static String getPathQuery(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf("/", n >= 0 ? (string.lastIndexOf("/", n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        if (string.lastIndexOf("#") > n2) {
            n3 = string.lastIndexOf("#");
        }
        return n2 < 0 ? (n >= 0 ? "/" : string) : string.substring(n2, n3);
    }

    public static String getFromPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf("/", n >= 0 ? (string.lastIndexOf("/", n - 1) >= 0 ? 0 : n + 2) : 0);
        return n2 < 0 ? (n >= 0 ? "/" : string) : string.substring(n2);
    }

    public static String encodeAll(String string) throws URIException {
        return URIUtil.encodeAll(string, URI.getDefaultProtocolCharset());
    }

    public static String encodeAll(String string, String string2) throws URIException {
        return URIUtil.encode(string, empty, string2);
    }

    public static String encodeWithinAuthority(String string) throws URIException {
        return URIUtil.encodeWithinAuthority(string, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinAuthority(String string, String string2) throws URIException {
        return URIUtil.encode(string, URI.allowed_within_authority, string2);
    }

    public static String encodePathQuery(String string) throws URIException {
        return URIUtil.encodePathQuery(string, URI.getDefaultProtocolCharset());
    }

    public static String encodePathQuery(String string, String string2) throws URIException {
        int n = string.indexOf(63);
        if (n < 0) {
            return URIUtil.encode(string, URI.allowed_abs_path, string2);
        }
        return URIUtil.encode(string.substring(0, n), URI.allowed_abs_path, string2) + '?' + URIUtil.encode(string.substring(n + 1), URI.allowed_query, string2);
    }

    public static String encodeWithinPath(String string) throws URIException {
        return URIUtil.encodeWithinPath(string, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinPath(String string, String string2) throws URIException {
        return URIUtil.encode(string, URI.allowed_within_path, string2);
    }

    public static String encodePath(String string) throws URIException {
        return URIUtil.encodePath(string, URI.getDefaultProtocolCharset());
    }

    public static String encodePath(String string, String string2) throws URIException {
        return URIUtil.encode(string, URI.allowed_abs_path, string2);
    }

    public static String encodeWithinQuery(String string) throws URIException {
        return URIUtil.encodeWithinQuery(string, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinQuery(String string, String string2) throws URIException {
        return URIUtil.encode(string, URI.allowed_within_query, string2);
    }

    public static String encodeQuery(String string) throws URIException {
        return URIUtil.encodeQuery(string, URI.getDefaultProtocolCharset());
    }

    public static String encodeQuery(String string, String string2) throws URIException {
        return URIUtil.encode(string, URI.allowed_query, string2);
    }

    public static String encode(String string, BitSet bitSet) throws URIException {
        return URIUtil.encode(string, bitSet, URI.getDefaultProtocolCharset());
    }

    public static String encode(String string, BitSet bitSet, String string2) throws URIException {
        byte[] byArray = URLCodec.encodeUrl((BitSet)bitSet, (byte[])EncodingUtil.getBytes(string, string2));
        return EncodingUtil.getAsciiString(byArray);
    }

    public static String decode(String string) throws URIException {
        try {
            byte[] byArray = URLCodec.decodeUrl((byte[])EncodingUtil.getAsciiBytes(string));
            return EncodingUtil.getString(byArray, URI.getDefaultProtocolCharset());
        }
        catch (DecoderException decoderException) {
            throw new URIException(decoderException.getMessage());
        }
    }

    public static String decode(String string, String string2) throws URIException {
        return Coder.decode(string.toCharArray(), string2);
    }

    protected static class Coder
    extends URI {
        protected Coder() {
        }

        public static char[] encode(String string, BitSet bitSet, String string2) throws URIException {
            return URI.encode(string, bitSet, string2);
        }

        public static String decode(char[] cArray, String string) throws URIException {
            return URI.decode(cArray, string);
        }

        public static boolean verifyEscaped(char[] cArray) {
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c > '\u0080') {
                    return false;
                }
                if (c != '%' || Character.digit(cArray[++i], 16) != -1 && Character.digit(cArray[++i], 16) != -1) continue;
                return false;
            }
            return true;
        }

        public static String replace(String string, char[] cArray, char[] cArray2) {
            for (int i = cArray.length; i > 0; --i) {
                string = Coder.replace(string, cArray[i], cArray2[i]);
            }
            return string.toString();
        }

        public static String replace(String string, char c, char c2) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = 0;
            do {
                if ((n = string.indexOf(c)) >= 0) {
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(c2);
                } else {
                    stringBuffer.append(string.substring(n2));
                }
                n2 = n;
            } while (n >= 0);
            return stringBuffer.toString();
        }
    }
}

