/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpMethodParams
extends DefaultHttpParams {
    private static final Log LOG = LogFactory.getLog(HttpMethodParams.class);
    public static final String USER_AGENT = "http.useragent";
    public static final String PROTOCOL_VERSION = "http.protocol.version";
    public static final String UNAMBIGUOUS_STATUS_LINE = "http.protocol.unambiguous-statusline";
    public static final String SINGLE_COOKIE_HEADER = "http.protocol.single-cookie-header";
    public static final String STRICT_TRANSFER_ENCODING = "http.protocol.strict-transfer-encoding";
    public static final String REJECT_HEAD_BODY = "http.protocol.reject-head-body";
    public static final String HEAD_BODY_CHECK_TIMEOUT = "http.protocol.head-body-timeout";
    public static final String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    public static final String CREDENTIAL_CHARSET = "http.protocol.credential-charset";
    public static final String HTTP_ELEMENT_CHARSET = "http.protocol.element-charset";
    public static final String HTTP_CONTENT_CHARSET = "http.protocol.content-charset";
    public static final String COOKIE_POLICY = "http.protocol.cookie-policy";
    public static final String WARN_EXTRA_INPUT = "http.protocol.warn-extra-input";
    public static final String STATUS_LINE_GARBAGE_LIMIT = "http.protocol.status-line-garbage-limit";
    public static final String SO_TIMEOUT = "http.socket.timeout";
    public static final String DATE_PATTERNS = "http.dateparser.patterns";
    public static final String RETRY_HANDLER = "http.method.retry-handler";
    public static final String BUFFER_WARN_TRIGGER_LIMIT = "http.method.response.buffer.warnlimit";
    public static final String VIRTUAL_HOST = "http.virtual-host";
    public static final String MULTIPART_BOUNDARY = "http.method.multipart.boundary";
    private static final String[] PROTOCOL_STRICTNESS_PARAMETERS = new String[]{"http.protocol.unambiguous-statusline", "http.protocol.single-cookie-header", "http.protocol.strict-transfer-encoding", "http.protocol.reject-head-body", "http.protocol.warn-extra-input"};

    public HttpMethodParams() {
        super(HttpMethodParams.getDefaultParams());
    }

    public HttpMethodParams(HttpParams httpParams) {
        super(httpParams);
    }

    public String getHttpElementCharset() {
        String string = (String)this.getParameter(HTTP_ELEMENT_CHARSET);
        if (string == null) {
            LOG.warn((Object)"HTTP element charset not configured, using US-ASCII");
            string = "US-ASCII";
        }
        return string;
    }

    public void setHttpElementCharset(String string) {
        this.setParameter(HTTP_ELEMENT_CHARSET, string);
    }

    public String getContentCharset() {
        String string = (String)this.getParameter(HTTP_CONTENT_CHARSET);
        if (string == null) {
            LOG.warn((Object)"Default content charset not configured, using ISO-8859-1");
            string = "ISO-8859-1";
        }
        return string;
    }

    public void setContentCharset(String string) {
        this.setParameter(HTTP_CONTENT_CHARSET, string);
    }

    public String getCredentialCharset() {
        String string = (String)this.getParameter(CREDENTIAL_CHARSET);
        if (string == null) {
            LOG.debug((Object)"Credential charset not configured, using HTTP element charset");
            string = this.getHttpElementCharset();
        }
        return string;
    }

    public void setCredentialCharset(String string) {
        this.setParameter(CREDENTIAL_CHARSET, string);
    }

    public HttpVersion getVersion() {
        Object object = this.getParameter(PROTOCOL_VERSION);
        if (object == null) {
            return HttpVersion.HTTP_1_1;
        }
        return (HttpVersion)object;
    }

    public void setVersion(HttpVersion httpVersion) {
        this.setParameter(PROTOCOL_VERSION, httpVersion);
    }

    public String getCookiePolicy() {
        Object object = this.getParameter(COOKIE_POLICY);
        if (object == null) {
            return "default";
        }
        return (String)object;
    }

    public void setCookiePolicy(String string) {
        this.setParameter(COOKIE_POLICY, string);
    }

    public int getSoTimeout() {
        return this.getIntParameter(SO_TIMEOUT, 0);
    }

    public void setSoTimeout(int n) {
        this.setIntParameter(SO_TIMEOUT, n);
    }

    public void setVirtualHost(String string) {
        this.setParameter(VIRTUAL_HOST, string);
    }

    public String getVirtualHost() {
        return (String)this.getParameter(VIRTUAL_HOST);
    }

    public void makeStrict() {
        this.setParameters(PROTOCOL_STRICTNESS_PARAMETERS, Boolean.TRUE);
        this.setIntParameter(STATUS_LINE_GARBAGE_LIMIT, 0);
    }

    public void makeLenient() {
        this.setParameters(PROTOCOL_STRICTNESS_PARAMETERS, Boolean.FALSE);
        this.setIntParameter(STATUS_LINE_GARBAGE_LIMIT, Integer.MAX_VALUE);
    }
}

