/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.ExpectContinueMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EntityEnclosingMethod
extends ExpectContinueMethod {
    public static final long CONTENT_LENGTH_AUTO = -2L;
    public static final long CONTENT_LENGTH_CHUNKED = -1L;
    private static final Log LOG = LogFactory.getLog(EntityEnclosingMethod.class);
    private InputStream requestStream = null;
    private String requestString = null;
    private RequestEntity requestEntity;
    private int repeatCount = 0;
    private long requestContentLength = -2L;
    private boolean chunked = false;

    public EntityEnclosingMethod() {
        this.setFollowRedirects(false);
    }

    public EntityEnclosingMethod(String string) {
        super(string);
        this.setFollowRedirects(false);
    }

    protected boolean hasRequestContent() {
        LOG.trace((Object)"enter EntityEnclosingMethod.hasRequestContent()");
        return this.requestEntity != null || this.requestStream != null || this.requestString != null;
    }

    protected void clearRequestBody() {
        LOG.trace((Object)"enter EntityEnclosingMethod.clearRequestBody()");
        this.requestStream = null;
        this.requestString = null;
        this.requestEntity = null;
    }

    protected byte[] generateRequestBody() {
        LOG.trace((Object)"enter EntityEnclosingMethod.renerateRequestBody()");
        return null;
    }

    protected RequestEntity generateRequestEntity() {
        byte[] byArray = this.generateRequestBody();
        if (byArray != null) {
            this.requestEntity = new ByteArrayRequestEntity(byArray);
        } else if (this.requestStream != null) {
            this.requestEntity = new InputStreamRequestEntity(this.requestStream, this.requestContentLength);
            this.requestStream = null;
        } else if (this.requestString != null) {
            String string = this.getRequestCharSet();
            try {
                this.requestEntity = new StringRequestEntity(this.requestString, null, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(string + " not supported"));
                }
                this.requestEntity = new StringRequestEntity(this.requestString);
            }
        }
        return this.requestEntity;
    }

    public boolean getFollowRedirects() {
        return false;
    }

    public void setFollowRedirects(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Entity enclosing requests cannot be redirected without user intervention");
        }
        super.setFollowRedirects(false);
    }

    public void setRequestContentLength(int n) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestContentLength(int)");
        this.requestContentLength = n;
    }

    public String getRequestCharSet() {
        if (this.getRequestHeader("Content-Type") == null) {
            if (this.requestEntity != null) {
                return this.getContentCharSet(new Header("Content-Type", this.requestEntity.getContentType()));
            }
            return super.getRequestCharSet();
        }
        return super.getRequestCharSet();
    }

    public void setRequestContentLength(long l) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestContentLength(int)");
        this.requestContentLength = l;
    }

    public void setContentChunked(boolean bl) {
        this.chunked = bl;
    }

    protected long getRequestContentLength() {
        LOG.trace((Object)"enter EntityEnclosingMethod.getRequestContentLength()");
        if (!this.hasRequestContent()) {
            return 0L;
        }
        if (this.chunked) {
            return -1L;
        }
        if (this.requestEntity == null) {
            this.requestEntity = this.generateRequestEntity();
        }
        return this.requestEntity == null ? 0L : this.requestEntity.getContentLength();
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        RequestEntity requestEntity;
        LOG.trace((Object)"enter EntityEnclosingMethod.addRequestHeaders(HttpState, HttpConnection)");
        super.addRequestHeaders(httpState, httpConnection);
        this.addContentLengthRequestHeader(httpState, httpConnection);
        if (this.getRequestHeader("Content-Type") == null && (requestEntity = this.getRequestEntity()) != null && requestEntity.getContentType() != null) {
            this.setRequestHeader("Content-Type", requestEntity.getContentType());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addContentLengthRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter EntityEnclosingMethod.addContentLengthRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("content-length") != null || this.getRequestHeader("Transfer-Encoding") != null) return;
        long l = this.getRequestContentLength();
        if (l < 0L) {
            if (!this.getEffectiveVersion().greaterEquals(HttpVersion.HTTP_1_1)) throw new ProtocolException(this.getEffectiveVersion() + " does not support chunk encoding");
            this.addRequestHeader("Transfer-Encoding", "chunked");
            return;
        } else {
            this.addRequestHeader("Content-Length", String.valueOf(l));
        }
    }

    public void setRequestBody(InputStream inputStream) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestBody(InputStream)");
        this.clearRequestBody();
        this.requestStream = inputStream;
    }

    public void setRequestBody(String string) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestBody(String)");
        this.clearRequestBody();
        this.requestString = string;
    }

    protected boolean writeRequestBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter EntityEnclosingMethod.writeRequestBody(HttpState, HttpConnection)");
        if (!this.hasRequestContent()) {
            LOG.debug((Object)"Request body has not been specified");
            return true;
        }
        if (this.requestEntity == null) {
            this.requestEntity = this.generateRequestEntity();
        }
        if (this.requestEntity == null) {
            LOG.debug((Object)"Request body is empty");
            return true;
        }
        long l = this.getRequestContentLength();
        if (this.repeatCount > 0 && !this.requestEntity.isRepeatable()) {
            throw new ProtocolException("Unbuffered entity enclosing request can not be repeated.");
        }
        ++this.repeatCount;
        OutputStream outputStream = httpConnection.getRequestOutputStream();
        if (l < 0L) {
            outputStream = new ChunkedOutputStream(outputStream);
        }
        this.requestEntity.writeRequest(outputStream);
        if (outputStream instanceof ChunkedOutputStream) {
            ((ChunkedOutputStream)outputStream).finish();
        }
        outputStream.flush();
        LOG.debug((Object)"Request body sent");
        return true;
    }

    public void recycle() {
        LOG.trace((Object)"enter EntityEnclosingMethod.recycle()");
        this.clearRequestBody();
        this.requestContentLength = -2L;
        this.repeatCount = 0;
        this.chunked = false;
        super.recycle();
    }

    public RequestEntity getRequestEntity() {
        return this.generateRequestEntity();
    }

    public void setRequestEntity(RequestEntity requestEntity) {
        this.clearRequestBody();
        this.requestEntity = requestEntity;
    }
}

